/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import java.io.Serializable;
import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.storage.ResourceReference;

public class DatasetCopyIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DataverseName dataverse;
    private final String dataset;
    private final String rebalance;

    private DatasetCopyIdentifier(DataverseName dataverse, String datasetName, String rebalance) {
        this.dataverse = dataverse;
        this.dataset = datasetName;
        this.rebalance = rebalance;
    }

    public static DatasetCopyIdentifier of(DataverseName dataverse, String datasetName, String rebalance) {
        return new DatasetCopyIdentifier(dataverse, datasetName, rebalance);
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getRebalance() {
        return this.rebalance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetCopyIdentifier that = (DatasetCopyIdentifier)o;
        return Objects.equals(this.dataverse, that.dataverse) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.rebalance, that.rebalance);
    }

    public int hashCode() {
        return Objects.hash(this.dataverse, this.dataset, this.rebalance);
    }

    public DataverseName getDataverse() {
        return this.dataverse;
    }

    public boolean isMatch(ResourceReference resourceReference) {
        return resourceReference.getDataverse().equals(this.dataverse.getCanonicalForm()) && resourceReference.getDataset().equals(this.dataset) && resourceReference.getRebalance().equals(this.rebalance);
    }

    public String toString() {
        return "DatasetCopyIdentifier{dataset='" + this.dataset + '\'' + ", dataverse='" + this.dataverse + '\'' + ", rebalance='" + this.rebalance + '\'' + '}';
    }
}

