/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.rewrites.VariableSubstitutionEnvironment;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.CloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.common.visitor.base.AbstractQueryExpressionVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.SourceLocation;

public abstract class AbstractInlineUdfsVisitor
extends AbstractQueryExpressionVisitor<Boolean, List<FunctionDecl>> {
    protected final LangRewritingContext context;
    protected final CloneAndSubstituteVariablesVisitor cloneVisitor;
    private final IRewriterFactory rewriterFactory;
    private final List<FunctionDecl> declaredFunctions;
    private final MetadataProvider metadataProvider;

    public AbstractInlineUdfsVisitor(LangRewritingContext context, IRewriterFactory rewriterFactory, List<FunctionDecl> declaredFunctions, MetadataProvider metadataProvider, CloneAndSubstituteVariablesVisitor cloneVisitor) {
        this.context = context;
        this.cloneVisitor = cloneVisitor;
        this.rewriterFactory = rewriterFactory;
        this.declaredFunctions = declaredFunctions;
        this.metadataProvider = metadataProvider;
    }

    protected abstract Expression generateQueryExpression(List<LetClause> var1, Expression var2) throws CompilationException;

    @Override
    public Boolean visit(Query q, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(q.getBody(), arg);
        q.setBody((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(FunctionDecl fd, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(fd.getFuncBody(), arg);
        fd.setFuncBody((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(ListConstructor lc, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, List<Expression>> p = this.inlineUdfsInExprList(lc.getExprList(), arg);
        lc.setExprList((List)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(RecordConstructor rc, List<FunctionDecl> arg) throws CompilationException {
        boolean changed = false;
        for (FieldBinding b : rc.getFbList()) {
            Pair<Boolean, Expression> leftExprInlined = this.inlineUdfsInExpr(b.getLeftExpr(), arg);
            b.setLeftExpr((Expression)leftExprInlined.second);
            changed = changed || (Boolean)leftExprInlined.first != false;
            Pair<Boolean, Expression> rightExprInlined = this.inlineUdfsInExpr(b.getRightExpr(), arg);
            b.setRightExpr((Expression)rightExprInlined.second);
            changed = changed || (Boolean)rightExprInlined.first != false;
        }
        return changed;
    }

    @Override
    public Boolean visit(CallExpr callExpr, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, List<Expression>> p = this.inlineUdfsInExprList(callExpr.getExprList(), arg);
        callExpr.setExprList((List)p.second);
        boolean changed = (Boolean)p.first;
        if (callExpr.hasAggregateFilterExpr()) {
            Pair<Boolean, Expression> be = this.inlineUdfsInExpr(callExpr.getAggregateFilterExpr(), arg);
            callExpr.setAggregateFilterExpr((Expression)be.second);
            changed |= ((Boolean)be.first).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(OperatorExpr ifbo, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, List<Expression>> p = this.inlineUdfsInExprList(ifbo.getExprList(), arg);
        ifbo.setExprList((List)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(FieldAccessor fa, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(fa.getExpr(), arg);
        fa.setExpr((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(IndexAccessor fa, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(fa.getExpr(), arg);
        fa.setExpr((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(IfExpr ifexpr, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, Expression> p1 = this.inlineUdfsInExpr(ifexpr.getCondExpr(), arg);
        ifexpr.setCondExpr((Expression)p1.second);
        Pair<Boolean, Expression> p2 = this.inlineUdfsInExpr(ifexpr.getThenExpr(), arg);
        ifexpr.setThenExpr((Expression)p2.second);
        Pair<Boolean, Expression> p3 = this.inlineUdfsInExpr(ifexpr.getElseExpr(), arg);
        ifexpr.setElseExpr((Expression)p3.second);
        return (Boolean)p1.first != false || (Boolean)p2.first != false || (Boolean)p3.first != false;
    }

    @Override
    public Boolean visit(QuantifiedExpression qe, List<FunctionDecl> arg) throws CompilationException {
        boolean changed = false;
        for (QuantifiedPair t : qe.getQuantifiedList()) {
            Pair<Boolean, Expression> p = this.inlineUdfsInExpr(t.getExpr(), arg);
            t.setExpr((Expression)p.second);
            if (!((Boolean)p.first).booleanValue()) continue;
            changed = true;
        }
        Pair<Boolean, Expression> p2 = this.inlineUdfsInExpr(qe.getSatisfiesExpr(), arg);
        qe.setSatisfiesExpr((Expression)p2.second);
        return changed || (Boolean)p2.first != false;
    }

    @Override
    public Boolean visit(LetClause lc, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(lc.getBindingExpr(), arg);
        lc.setBindingExpr((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(WhereClause wc, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(wc.getWhereExpr(), arg);
        wc.setWhereExpr((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(OrderbyClause oc, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, List<Expression>> p = this.inlineUdfsInExprList(oc.getOrderbyList(), arg);
        oc.setOrderbyList((List)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(GroupbyClause gc, List<FunctionDecl> arg) throws CompilationException {
        boolean changed = false;
        List<List<GbyVariableExpressionPair>> gbyList = gc.getGbyPairList();
        ArrayList<List<GbyVariableExpressionPair>> newGbyList = new ArrayList<List<GbyVariableExpressionPair>>(gbyList.size());
        for (List<GbyVariableExpressionPair> gbyPairList : gbyList) {
            Pair<Boolean, List<GbyVariableExpressionPair>> p1 = this.inlineUdfsInGbyPairList(gbyPairList, arg);
            newGbyList.add((List<GbyVariableExpressionPair>)p1.second);
            changed |= ((Boolean)p1.first).booleanValue();
        }
        gc.setGbyPairList(newGbyList);
        if (gc.hasDecorList()) {
            Pair<Boolean, List<GbyVariableExpressionPair>> p2 = this.inlineUdfsInGbyPairList(gc.getDecorPairList(), arg);
            gc.setDecorPairList((List)p2.second);
            changed |= ((Boolean)p2.first).booleanValue();
        }
        if (gc.hasGroupFieldList()) {
            Pair<Boolean, List<Pair<Expression, Identifier>>> p3 = this.inlineUdfsInFieldList(gc.getGroupFieldList(), arg);
            gc.setGroupFieldList((List)p3.second);
            changed |= ((Boolean)p3.first).booleanValue();
        }
        if (gc.hasWithMap()) {
            Pair<Boolean, Map<Expression, VariableExpr>> p4 = this.inlineUdfsInVarMap(gc.getWithVarMap(), arg);
            gc.setWithVarMap((Map)p4.second);
            changed |= ((Boolean)p4.first).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(LimitClause lc, List<FunctionDecl> arg) throws CompilationException {
        Pair<Boolean, Expression> p1 = this.inlineUdfsInExpr(lc.getLimitExpr(), arg);
        lc.setLimitExpr((Expression)p1.second);
        boolean changed = (Boolean)p1.first;
        if (lc.getOffset() != null) {
            Pair<Boolean, Expression> p2 = this.inlineUdfsInExpr(lc.getOffset(), arg);
            lc.setOffset((Expression)p2.second);
            changed = changed || (Boolean)p2.first != false;
        }
        return changed;
    }

    @Override
    public Boolean visit(UnaryExpr u, List<FunctionDecl> arg) throws CompilationException {
        return u.getExpr().accept(this, arg);
    }

    @Override
    public Boolean visit(VariableExpr v, List<FunctionDecl> arg) throws CompilationException {
        return false;
    }

    @Override
    public Boolean visit(LiteralExpr l, List<FunctionDecl> arg) throws CompilationException {
        return false;
    }

    @Override
    public Boolean visit(InsertStatement insert, List<FunctionDecl> arg) throws CompilationException {
        boolean changed = false;
        Expression returnExpression = insert.getReturnExpression();
        if (returnExpression != null) {
            Pair<Boolean, Expression> rewrittenReturnExpr = this.inlineUdfsInExpr(returnExpression, arg);
            insert.setReturnExpression((Expression)rewrittenReturnExpr.second);
            changed |= ((Boolean)rewrittenReturnExpr.first).booleanValue();
        }
        Pair<Boolean, Expression> rewrittenBodyExpression = this.inlineUdfsInExpr(insert.getBody(), arg);
        insert.setBody((Expression)rewrittenBodyExpression.second);
        return changed || (Boolean)rewrittenBodyExpression.first != false;
    }

    protected Pair<Boolean, Expression> inlineUdfsInExpr(Expression expr, List<FunctionDecl> arg) throws CompilationException {
        if (expr.getKind() != Expression.Kind.CALL_EXPRESSION) {
            boolean r = expr.accept(this, arg);
            return new Pair((Object)r, (Object)expr);
        }
        CallExpr f = (CallExpr)expr;
        boolean r = expr.accept(this, arg);
        FunctionDecl implem = AbstractInlineUdfsVisitor.findFuncDeclaration(f.getFunctionSignature(), arg);
        if (implem == null) {
            return new Pair((Object)r, (Object)expr);
        }
        if (f.hasAggregateFilterExpr()) {
            throw new CompilationException(1121, f.getSourceLocation(), new Serializable[0]);
        }
        implem.setFuncBody(this.rewriteFunctionBody(implem));
        ArrayList<LetClause> clauses = new ArrayList<LetClause>();
        Iterator<VarIdentifier> paramIter = implem.getParamList().iterator();
        VariableSubstitutionEnvironment subts = new VariableSubstitutionEnvironment();
        for (Expression e : f.getExprList()) {
            VarIdentifier param = paramIter.next();
            if (e.getKind() == Expression.Kind.VARIABLE_EXPRESSION) {
                subts.addSubstituion(new VariableExpr(param), e);
                continue;
            }
            SourceLocation sourceLoc = e.getSourceLocation();
            VarIdentifier newV = this.context.newVariable();
            Pair<ILangExpression, VariableSubstitutionEnvironment> p1 = e.accept(this.cloneVisitor, new VariableSubstitutionEnvironment());
            VariableExpr newVRef1 = new VariableExpr(newV);
            newVRef1.setSourceLocation(sourceLoc);
            LetClause c = new LetClause(newVRef1, (Expression)p1.first);
            c.setSourceLocation(sourceLoc);
            clauses.add(c);
            VariableExpr newVRef2 = new VariableExpr(newV);
            newVRef2.setSourceLocation(sourceLoc);
            subts.addSubstituion(new VariableExpr(param), newVRef2);
        }
        Pair<ILangExpression, VariableSubstitutionEnvironment> p2 = implem.getFuncBody().accept(this.cloneVisitor, subts);
        Expression resExpr = clauses.isEmpty() ? (Expression)p2.first : this.generateQueryExpression(clauses, (Expression)p2.first);
        return new Pair((Object)true, (Object)resExpr);
    }

    protected Pair<Boolean, List<Expression>> inlineUdfsInExprList(List<Expression> exprList, List<FunctionDecl> fds) throws CompilationException {
        ArrayList<Object> newList = new ArrayList<Object>(exprList.size());
        boolean changed = false;
        for (Expression e : exprList) {
            Pair<Boolean, Expression> be = this.inlineUdfsInExpr(e, fds);
            newList.add(be.second);
            changed |= ((Boolean)be.first).booleanValue();
        }
        return new Pair((Object)changed, newList);
    }

    private Pair<Boolean, List<GbyVariableExpressionPair>> inlineUdfsInGbyPairList(List<GbyVariableExpressionPair> gbyPairList, List<FunctionDecl> fds) throws CompilationException {
        ArrayList<GbyVariableExpressionPair> newList = new ArrayList<GbyVariableExpressionPair>(gbyPairList.size());
        boolean changed = false;
        for (GbyVariableExpressionPair p : gbyPairList) {
            Pair<Boolean, Expression> be = this.inlineUdfsInExpr(p.getExpr(), fds);
            newList.add(new GbyVariableExpressionPair(p.getVar(), (Expression)be.second));
            changed |= ((Boolean)be.first).booleanValue();
        }
        return new Pair((Object)changed, newList);
    }

    protected Pair<Boolean, List<Pair<Expression, Identifier>>> inlineUdfsInFieldList(List<Pair<Expression, Identifier>> fieldList, List<FunctionDecl> fds) throws CompilationException {
        ArrayList<Pair> newList = new ArrayList<Pair>(fieldList.size());
        boolean changed = false;
        for (Pair<Expression, Identifier> p : fieldList) {
            Pair<Boolean, Expression> be = this.inlineUdfsInExpr((Expression)p.first, fds);
            newList.add(new Pair(be.second, p.second));
            changed |= ((Boolean)be.first).booleanValue();
        }
        return new Pair((Object)changed, newList);
    }

    private Pair<Boolean, Map<Expression, VariableExpr>> inlineUdfsInVarMap(Map<Expression, VariableExpr> varMap, List<FunctionDecl> fds) throws CompilationException {
        HashMap<Object, VariableExpr> newMap = new HashMap<Object, VariableExpr>();
        boolean changed = false;
        for (Map.Entry<Expression, VariableExpr> me : varMap.entrySet()) {
            Pair<Boolean, Expression> be = this.inlineUdfsInExpr(me.getKey(), fds);
            newMap.put(be.second, me.getValue());
            changed |= ((Boolean)be.first).booleanValue();
        }
        return new Pair((Object)changed, newMap);
    }

    private Expression rewriteFunctionBody(FunctionDecl fnDecl) throws CompilationException {
        Dataverse fnDataverse;
        SourceLocation sourceLoc = fnDecl.getSourceLocation();
        DataverseName fnDataverseName = fnDecl.getSignature().getDataverseName();
        Dataverse defaultDataverse = this.metadataProvider.getDefaultDataverse();
        if (fnDataverseName == null || fnDataverseName.equals((Object)defaultDataverse.getDataverseName())) {
            fnDataverse = defaultDataverse;
        } else {
            try {
                fnDataverse = this.metadataProvider.findDataverse(fnDataverseName);
            }
            catch (AlgebricksException e) {
                throw new CompilationException(1063, (Throwable)e, sourceLoc, new Serializable[]{fnDataverseName});
            }
        }
        this.metadataProvider.setDefaultDataverse(fnDataverse);
        try {
            Query wrappedQuery = new Query(false);
            wrappedQuery.setSourceLocation(sourceLoc);
            wrappedQuery.setBody(fnDecl.getFuncBody());
            wrappedQuery.setTopLevel(false);
            IQueryRewriter queryRewriter = this.rewriterFactory.createQueryRewriter();
            queryRewriter.rewrite(this.declaredFunctions, wrappedQuery, this.metadataProvider, this.context, true, fnDecl.getParamList());
            Expression expression = wrappedQuery.getBody();
            return expression;
        }
        catch (CompilationException e) {
            throw new CompilationException(1122, (Throwable)e, new Serializable[]{fnDecl.getSignature(), e.getMessage()});
        }
        finally {
            this.metadataProvider.setDefaultDataverse(defaultDataverse);
        }
    }

    private static FunctionDecl findFuncDeclaration(FunctionSignature fid, List<FunctionDecl> sequence) {
        for (FunctionDecl f : sequence) {
            if (!f.getSignature().equals((Object)fid)) continue;
            return f;
        }
        return null;
    }
}

