/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.io.DataOutput;
import java.io.Serializable;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.literal.DoubleLiteral;
import org.apache.asterix.lang.common.literal.FloatLiteral;
import org.apache.asterix.lang.common.literal.IntegerLiteral;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.om.base.AMutableDate;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AMutableTime;
import org.apache.asterix.om.base.temporal.ADateParserFactory;
import org.apache.asterix.om.base.temporal.ADateTimeParserFactory;
import org.apache.asterix.om.base.temporal.ATimeParserFactory;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public class RangeMapBuilder {
    private RangeMapBuilder() {
    }

    public static RangeMap parseHint(Expression expression) throws CompilationException {
        if (expression.getKind() != Expression.Kind.LIST_CONSTRUCTOR_EXPRESSION) {
            throw new CompilationException(1094, expression.getSourceLocation(), new Serializable[0]);
        }
        ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        DataOutput out = abvs.getDataOutput();
        List<Expression> el = ((ListConstructor)expression).getExprList();
        int[] offsets = new int[el.size()];
        for (int i = 0; i < el.size(); ++i) {
            Expression item = el.get(i);
            if (item.getKind() == Expression.Kind.LITERAL_EXPRESSION) {
                RangeMapBuilder.parseLiteralToBytes((LiteralExpr)item, out);
                offsets[i] = abvs.getLength();
                continue;
            }
            if (item.getKind() == Expression.Kind.CALL_EXPRESSION) {
                RangeMapBuilder.parseExpressionToBytes((CallExpr)item, out);
                offsets[i] = abvs.getLength();
                continue;
            }
            throw new CompilationException(1094, expression.getSourceLocation(), new Serializable[0]);
        }
        return new RangeMap(1, abvs.getByteArray(), offsets);
    }

    private static void parseExpressionToBytes(CallExpr item, DataOutput out) throws CompilationException {
        block7: {
            AMutableDate aDate = new AMutableDate(0);
            AMutableTime aTime = new AMutableTime(0);
            AMutableDateTime aDateTime = new AMutableDateTime(0L);
            if (item.getExprList().get(0).getKind() != Expression.Kind.LITERAL_EXPRESSION) {
                throw new CompilationException(1094, item.getSourceLocation(), new Serializable[0]);
            }
            LiteralExpr argumentLiteralExpr = (LiteralExpr)item.getExprList().get(0);
            if (argumentLiteralExpr.getValue().getLiteralType() != Literal.Type.STRING) {
                throw new CompilationException(1094, item.getSourceLocation(), new Serializable[0]);
            }
            String value = argumentLiteralExpr.getValue().toString();
            try {
                if (BuiltinFunctions.DATE_CONSTRUCTOR.getName().equals(item.getFunctionSignature().getName())) {
                    int chrononTimeInDays = ADateParserFactory.parseDatePartInDays((String)value, (int)0, (int)value.length());
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
                    aDate.setValue(chrononTimeInDays);
                    serde.serialize((Object)aDate, out);
                    break block7;
                }
                if (BuiltinFunctions.TIME_CONSTRUCTOR.getName().equals(item.getFunctionSignature().getName())) {
                    int chrononTimeInMillis = ATimeParserFactory.parseTimePart((String)value, (int)0, (int)value.length());
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ATIME);
                    aTime.setValue(chrononTimeInMillis);
                    serde.serialize((Object)aTime, out);
                    break block7;
                }
                if (BuiltinFunctions.DATETIME_CONSTRUCTOR.getName().equals(item.getFunctionSignature().getName())) {
                    long chronoDatetimeInMills = ADateTimeParserFactory.parseDateTimePart((String)value, (int)0, (int)value.length());
                    aDateTime.setValue(chronoDatetimeInMills);
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
                    serde.serialize((Object)aDateTime, out);
                    break block7;
                }
                throw new NotImplementedException("The range map builder has not been implemented for " + item.getFunctionSignature().getName() + " type of expressions.");
            }
            catch (HyracksException e) {
                throw new CompilationException(1094, (Throwable)e, item.getSourceLocation(), new Serializable[]{e.getMessage()});
            }
        }
    }

    private static void parseLiteralToBytes(LiteralExpr item, DataOutput out) throws CompilationException {
        AMutableDouble aDouble = new AMutableDouble(0.0);
        AMutableFloat aFloat = new AMutableFloat(0.0f);
        AMutableInt64 aInt64 = new AMutableInt64(0L);
        AMutableInt32 aInt32 = new AMutableInt32(0);
        AMutableString aString = new AMutableString("");
        Literal l = item.getValue();
        try {
            switch (l.getLiteralType()) {
                case DOUBLE: {
                    DoubleLiteral dl = (DoubleLiteral)l;
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                    aDouble.setValue(dl.getValue().doubleValue());
                    serde.serialize((Object)aDouble, out);
                    break;
                }
                case FLOAT: {
                    FloatLiteral fl = (FloatLiteral)l;
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
                    aFloat.setValue(fl.getValue().floatValue());
                    serde.serialize((Object)aFloat, out);
                    break;
                }
                case INTEGER: {
                    IntegerLiteral il = (IntegerLiteral)l;
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                    aInt32.setValue(il.getValue().intValue());
                    serde.serialize((Object)aInt32, out);
                    break;
                }
                case LONG: {
                    LongIntegerLiteral lil = (LongIntegerLiteral)l;
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                    aInt64.setValue(lil.getValue().longValue());
                    serde.serialize((Object)aInt64, out);
                    break;
                }
                case STRING: {
                    StringLiteral sl = (StringLiteral)l;
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
                    aString.setValue(sl.getValue());
                    serde.serialize((Object)aString, out);
                    break;
                }
                default: {
                    throw new NotImplementedException("The range map builder has not been implemented for " + (Object)((Object)item.getKind()) + " type of expressions.");
                }
            }
        }
        catch (HyracksDataException e) {
            throw new CompilationException(1094, (Throwable)e, item.getSourceLocation(), new Serializable[]{e.getMessage()});
        }
    }

    public static void verifyRangeOrder(RangeMap rangeMap, boolean ascending, SourceLocation sourceLoc) throws CompilationException {
        IBinaryComparatorFactory bcf;
        int fieldIndex = 0;
        int fieldType = rangeMap.getTag(0, 0);
        BinaryComparatorFactoryProvider comparatorFactory = BinaryComparatorFactoryProvider.INSTANCE;
        try {
            bcf = comparatorFactory.getBinaryComparatorFactory(ATypeTag.VALUE_TYPE_MAPPING[fieldType], ascending);
        }
        catch (RuntimeDataException e) {
            throw new CompilationException(1079, sourceLoc, new Serializable[]{e.getMessage()});
        }
        IBinaryComparator comparator = bcf.createBinaryComparator();
        int c = 0;
        for (int split = 1; split < rangeMap.getSplitCount(); ++split) {
            if (fieldType != rangeMap.getTag(fieldIndex, split)) {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Range field contains more than a single type of items (" + fieldType + " and " + rangeMap.getTag(fieldIndex, split) + ")."});
            }
            int previousSplit = split - 1;
            try {
                c = comparator.compare(rangeMap.getByteArray(), rangeMap.getStartOffset(fieldIndex, previousSplit), rangeMap.getLength(fieldIndex, previousSplit), rangeMap.getByteArray(), rangeMap.getStartOffset(fieldIndex, split), rangeMap.getLength(fieldIndex, split));
            }
            catch (HyracksDataException e) {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{e.getMessage()});
            }
            if (c < 0) continue;
            throw new CompilationException(1079, sourceLoc, new Serializable[]{"Range fields are not in sorted order."});
        }
    }
}

