/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.visitor.FormatPrintVisitor;

public class DataverseNameUtils {
    protected static Set<Character> validIdentifierChars;
    protected static Set<Character> validIdentifierStartChars;

    protected static boolean needQuotes(String str) {
        if (str.length() == 0) {
            return false;
        }
        if (!validIdentifierStartChars.contains(Character.valueOf(str.charAt(0)))) {
            return true;
        }
        for (char ch : str.toCharArray()) {
            if (validIdentifierChars.contains(Character.valueOf(ch))) continue;
            return true;
        }
        return false;
    }

    protected static String normalize(String str) {
        if (DataverseNameUtils.needQuotes(str)) {
            return FormatPrintVisitor.revertStringToQuoted(str);
        }
        return str;
    }

    public static String generateDataverseName(DataverseName dataverseName) {
        ArrayList dataverseNameParts = new ArrayList();
        StringBuilder sb = new StringBuilder();
        dataverseNameParts.clear();
        dataverseName.getParts(dataverseNameParts);
        int ln = dataverseNameParts.size();
        for (int i = 0; i < ln; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(DataverseNameUtils.normalize((String)dataverseNameParts.get(i)));
        }
        return sb.toString();
    }

    static {
        char ch;
        validIdentifierChars = new HashSet<Character>();
        validIdentifierStartChars = new HashSet<Character>();
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            validIdentifierChars.add(Character.valueOf(ch));
            validIdentifierStartChars.add(Character.valueOf(ch));
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            validIdentifierChars.add(Character.valueOf(ch));
            validIdentifierStartChars.add(Character.valueOf(ch));
        }
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            validIdentifierChars.add(Character.valueOf(ch));
        }
        validIdentifierChars.add(Character.valueOf('_'));
        validIdentifierChars.add(Character.valueOf('$'));
    }
}

