/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.CheckDatasetOnlyResolutionVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class VariableCheckAndRewriteVisitor
extends AbstractSqlppExpressionScopingVisitor {
    protected final MetadataProvider metadataProvider;

    public VariableCheckAndRewriteVisitor(LangRewritingContext context, MetadataProvider metadataProvider, Collection<VarIdentifier> externalVars) {
        super(context, externalVars);
        this.metadataProvider = metadataProvider;
    }

    @Override
    public Expression visit(VariableExpr varExpr, ILangExpression parent) throws CompilationException {
        String datasetName;
        if (this.resolveAsVariableReference(varExpr)) {
            return varExpr;
        }
        DataverseName dataverseName = this.metadataProvider.getDefaultDataverseName();
        CallExpr datasetExpr = this.resolveAsDataset(dataverseName, datasetName = SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar().getValue()).getValue(), parent, varExpr);
        return datasetExpr != null ? datasetExpr : this.resolveAsFieldAccessOverContextVar(varExpr);
    }

    @Override
    public Expression visit(FieldAccessor fa, ILangExpression parent) throws CompilationException {
        Expression leadingExpr = fa.getExpr();
        if (leadingExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION) {
            String datasetName;
            VariableExpr leadingVarExpr = (VariableExpr)leadingExpr;
            if (this.resolveAsVariableReference(leadingVarExpr)) {
                return fa;
            }
            String dataverseNamePart = SqlppVariableUtil.toUserDefinedVariableName(leadingVarExpr.getVar().getValue()).getValue();
            DataverseName dataverseName = DataverseName.createSinglePartName((String)dataverseNamePart);
            CallExpr datasetExpr = this.resolveAsDataset(dataverseName, datasetName = fa.getIdent().getValue(), parent, leadingVarExpr);
            if (datasetExpr != null) {
                return datasetExpr;
            }
            fa.setExpr((Expression)this.resolveAsFieldAccessOverContextVar(leadingVarExpr));
            return fa;
        }
        ArrayList<String> dataverseNameParts = new ArrayList<String>(4);
        Pair topExprs = new Pair(null, null);
        if (VariableCheckAndRewriteVisitor.extractDataverseName(fa.getExpr(), dataverseNameParts, (Pair<VariableExpr, FieldAccessor>)topExprs)) {
            String datasetName;
            VariableExpr topVarExpr = (VariableExpr)topExprs.getFirst();
            if (this.resolveAsVariableReference(topVarExpr)) {
                return fa;
            }
            DataverseName dataverseName = DataverseName.create(dataverseNameParts);
            CallExpr datasetExpr = this.resolveAsDataset(dataverseName, datasetName = fa.getIdent().getValue(), parent, topVarExpr);
            if (datasetExpr != null) {
                return datasetExpr;
            }
            FieldAccessor topFaExpr = (FieldAccessor)topExprs.getSecond();
            topFaExpr.setExpr((Expression)this.resolveAsFieldAccessOverContextVar(topVarExpr));
            return fa;
        }
        fa.setExpr((Expression)leadingExpr.accept((ILangVisitor)this, (Object)parent));
        return fa;
    }

    private boolean resolveAsVariableReference(VariableExpr varExpr) throws CompilationException {
        VarIdentifier varId = varExpr.getVar();
        String varName = varId.getValue();
        if (this.scopeChecker.isInForbiddenScopes(varName)) {
            throw new CompilationException(1075, varExpr.getSourceLocation(), new Serializable[0]);
        }
        Identifier ident = this.scopeChecker.lookupSymbol(varName);
        if (ident == null) {
            if (SqlppVariableUtil.isExternalVariableIdentifier(varId)) {
                throw new CompilationException(1086, varExpr.getSourceLocation(), new Serializable[]{SqlppVariableUtil.variableNameToDisplayedFieldName(varId.getValue())});
            }
            return false;
        }
        varExpr.setIsNewVar(false);
        varExpr.setVar((VarIdentifier)ident);
        return true;
    }

    private CallExpr resolveAsDataset(DataverseName dataverseName, String datasetName, ILangExpression parent, VariableExpr varExpr) throws CompilationException {
        if (!((Boolean)parent.accept((ILangVisitor)CheckDatasetOnlyResolutionVisitor.INSTANCE, (Object)varExpr)).booleanValue()) {
            return null;
        }
        SourceLocation sourceLoc = varExpr.getSourceLocation();
        Dataset dataset = this.findDataset(dataverseName, datasetName, sourceLoc);
        if (dataset == null) {
            throw this.createUnresolvableError(dataverseName, datasetName, sourceLoc);
        }
        this.metadataProvider.addAccessedDataset(dataset);
        ArrayList<LiteralExpr> argList = new ArrayList<LiteralExpr>(2);
        argList.add(new LiteralExpr((Literal)new StringLiteral(dataset.getDataverseName().getCanonicalForm())));
        argList.add(new LiteralExpr((Literal)new StringLiteral(dataset.getDatasetName())));
        CallExpr callExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.DATASET), argList);
        callExpr.setSourceLocation(sourceLoc);
        return callExpr;
    }

    private FieldAccessor resolveAsFieldAccessOverContextVar(VariableExpr varExpr) throws CompilationException {
        Map localVars = this.scopeChecker.getCurrentScope().getLiveVariables(this.scopeChecker.getPrecedingScope());
        Set contextVars = Scope.findVariablesAnnotatedBy(localVars.keySet(), (Scope.SymbolAnnotation)AbstractSqlppExpressionScopingVisitor.SqlppVariableAnnotation.CONTEXT_VARIABLE, (Map)localVars, (SourceLocation)varExpr.getSourceLocation());
        VariableExpr contextVar = VariableCheckAndRewriteVisitor.pickContextVar(contextVars, varExpr);
        return VariableCheckAndRewriteVisitor.generateFieldAccess((Expression)contextVar, varExpr.getVar(), varExpr.getSourceLocation());
    }

    static FieldAccessor generateFieldAccess(Expression sourceExpr, VarIdentifier fieldVar, SourceLocation sourceLoc) {
        VarIdentifier fieldName = SqlppVariableUtil.toUserDefinedVariableName(fieldVar.getValue());
        FieldAccessor fa = new FieldAccessor(sourceExpr, (Identifier)fieldName);
        fa.setSourceLocation(sourceLoc);
        return fa;
    }

    private static boolean extractDataverseName(Expression expr, List<String> outDataverseName, Pair<VariableExpr, FieldAccessor> outTopExprs) {
        switch (expr.getKind()) {
            case VARIABLE_EXPRESSION: {
                VariableExpr varExpr = (VariableExpr)expr;
                String varName = SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar().getValue()).getValue();
                outDataverseName.add(varName);
                outTopExprs.setFirst((Object)varExpr);
                return true;
            }
            case FIELD_ACCESSOR_EXPRESSION: {
                FieldAccessor faExpr = (FieldAccessor)expr;
                if (VariableCheckAndRewriteVisitor.extractDataverseName(faExpr.getExpr(), outDataverseName, outTopExprs)) {
                    outDataverseName.add(faExpr.getIdent().getValue());
                    if (outTopExprs.getSecond() == null) {
                        outTopExprs.setSecond((Object)faExpr);
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private CompilationException createUnresolvableError(DataverseName dataverseName, String datasetName, SourceLocation sourceLoc) {
        DataverseName defaultDataverseName = this.metadataProvider.getDefaultDataverseName();
        if (dataverseName == null && defaultDataverseName == null) {
            return new CompilationException(1076, sourceLoc, new Serializable[]{datasetName});
        }
        return new CompilationException(1077, sourceLoc, new Serializable[]{datasetName, dataverseName == null ? defaultDataverseName : dataverseName});
    }

    private Dataset findDataset(DataverseName dataverseName, String datasetName, SourceLocation sourceLoc) throws CompilationException {
        try {
            Pair dsName = this.metadataProvider.resolveDatasetNameUsingSynonyms(dataverseName, datasetName);
            if (dsName != null) {
                dataverseName = (DataverseName)dsName.first;
                datasetName = (String)dsName.second;
            }
            return this.metadataProvider.findDataset(dataverseName, datasetName);
        }
        catch (AlgebricksException e) {
            throw new CompilationException(1079, (Throwable)e, sourceLoc, new Serializable[]{e.getMessage()});
        }
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        if (FunctionMapUtil.isSql92AggregateFunction(callExpr.getFunctionSignature())) {
            return callExpr;
        }
        return super.visit(callExpr, arg);
    }

    @Override
    public Expression visit(WindowExpression winExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature fs = winExpr.getFunctionSignature();
        FunctionIdentifier winfi = FunctionMapUtil.getInternalWindowFunction(fs);
        if (winfi != null) {
            if (BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)winfi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.HAS_LIST_ARG)) {
                this.visitWindowExpressionExcludingExprListAndAggFilter(winExpr, arg);
                List<Expression> exprList = winExpr.getExprList();
                ArrayList<Expression> newExprList = new ArrayList<Expression>(exprList.size());
                Iterator<Expression> i = exprList.iterator();
                newExprList.add(i.next());
                while (i.hasNext()) {
                    newExprList.add(this.visit(i.next(), arg));
                }
                winExpr.setExprList(newExprList);
                return winExpr;
            }
            return super.visit(winExpr, arg);
        }
        if (FunctionMapUtil.isSql92AggregateFunction(fs)) {
            this.visitWindowExpressionExcludingExprListAndAggFilter(winExpr, arg);
            return winExpr;
        }
        return super.visit(winExpr, arg);
    }

    static VariableExpr pickContextVar(Collection<VariableExpr> contextVars, VariableExpr usedVar) throws CompilationException {
        switch (contextVars.size()) {
            case 0: {
                throw new CompilationException(1073, usedVar.getSourceLocation(), new Serializable[]{SqlppVariableUtil.toUserDefinedVariableName(usedVar.getVar().getValue()).getValue()});
            }
            case 1: {
                return contextVars.iterator().next();
            }
        }
        throw new CompilationException(1074, usedVar.getSourceLocation(), new Serializable[]{SqlppVariableUtil.toUserDefinedVariableName(usedVar.getVar().getValue()).getValue()});
    }
}

