/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.fixedsize;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.AbstractOnDiskInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class FixedSizeElementOnDiskInvertedListCursor
extends AbstractOnDiskInvertedListCursor {
    private final int elementSize;
    private int bufferEndElementIx = 0;
    protected final IInvertedListTupleReference bufferEndElementTuple;
    private int[] elementIndexes = new int[10];

    public FixedSizeElementOnDiskInvertedListCursor(IBufferCache bufferCache, int fileId, ITypeTraits[] invListFields, IHyracksTaskContext ctx, IIndexCursorStats stats) throws HyracksDataException {
        super(bufferCache, fileId, invListFields, ctx, stats);
        this.bufferEndElementTuple = InvertedIndexUtils.createInvertedListTupleReference(invListFields);
        int tmpSize = 0;
        for (int i = 0; i < invListFields.length; ++i) {
            tmpSize += invListFields[i].getFixedLength();
        }
        this.elementSize = tmpSize;
        this.currentOffsetForScan = -this.elementSize;
    }

    public void doNext() throws HyracksDataException {
        if (this.currentOffsetForScan + 2 * this.elementSize > this.bufferCache.getPageSize()) {
            ++this.currentPageIxForScan;
            this.currentOffsetForScan = 0;
        } else {
            this.currentOffsetForScan += this.elementSize;
        }
        if (this.currentElementIxForScan > this.bufferEndElementIx && this.endPageId > this.bufferEndPageId) {
            this.loadPages();
            this.currentOffsetForScan = 0;
        }
        ++this.currentElementIxForScan;
        this.tuple.reset(((ByteBuffer)this.buffers.get(this.currentPageIxForScan)).array(), this.currentOffsetForScan);
    }

    @Override
    protected void setBlockInfo() {
        super.setBlockInfo();
        this.bufferStartElementIx = this.bufferStartPageId == this.startPageId ? 0 : this.elementIndexes[this.bufferStartPageId - this.startPageId - 1] + 1;
        this.bufferEndElementIx = this.elementIndexes[this.bufferEndPageId - this.startPageId];
        this.getElementAtIndex(this.bufferEndElementIx, this.bufferEndElementTuple);
    }

    private void getElementAtIndex(int elementIx, IInvertedListTupleReference tuple) {
        int currentOff;
        int currentPageIx = this.binarySearch(this.elementIndexes, this.bufferStartPageId - this.startPageId, this.bufferNumLoadedPages, elementIx);
        if (currentPageIx < 0) {
            throw new IndexOutOfBoundsException("Requested index: " + elementIx + " from array with numElements: " + this.numElements);
        }
        if (currentPageIx == 0) {
            currentOff = this.startOff + elementIx * this.elementSize;
        } else {
            int relativeElementIx = elementIx - this.elementIndexes[currentPageIx - 1] - 1;
            currentOff = relativeElementIx * this.elementSize;
        }
        int bufferIdx = currentPageIx % this.buffers.size();
        tuple.reset(((ByteBuffer)this.buffers.get(bufferIdx)).array(), currentOff);
    }

    @Override
    public boolean containsKey(ITupleReference searchTuple, MultiComparator invListCmp) throws HyracksDataException {
        if (this.needToReadNextBlock(searchTuple, invListCmp)) {
            this.loadPages();
        }
        int mid = -1;
        int begin = this.lastRandomSearchedElementIx;
        int end = this.bufferEndElementIx;
        while (begin <= end) {
            mid = (begin + end) / 2;
            this.getElementAtIndex(mid, this.tuple);
            int cmp = invListCmp.compare(searchTuple, (ITupleReference)this.tuple);
            if (cmp < 0) {
                end = mid - 1;
                continue;
            }
            if (cmp > 0) {
                begin = mid + 1;
                continue;
            }
            this.lastRandomSearchedElementIx = mid;
            return true;
        }
        this.lastRandomSearchedElementIx = mid;
        return false;
    }

    private boolean needToReadNextBlock(ITupleReference searchTuple, MultiComparator invListCmp) throws HyracksDataException {
        return this.moreBlocksToRead && invListCmp.compare(searchTuple, (ITupleReference)this.bufferEndElementTuple) > 0;
    }

    @Override
    protected void setInvListInfo(int startPageId, int endPageId, int startOff, int numElements) throws HyracksDataException {
        super.setInvListInfo(startPageId, endPageId, startOff, numElements);
        if (this.numPages > this.elementIndexes.length) {
            this.elementIndexes = new int[this.numPages];
        }
        this.currentOffsetForScan = startOff - this.elementSize;
        int cumulElements = (this.bufferCache.getPageSize() - startOff) / this.elementSize;
        this.elementIndexes[0] = cumulElements - 1;
        for (int i = 1; i < this.numPages - 1; ++i) {
            this.elementIndexes[i] = this.elementIndexes[i - 1] + this.bufferCache.getPageSize() / this.elementSize;
        }
        this.elementIndexes[this.numPages - 1] = numElements - 1;
    }

    @Override
    public String printInvList(ISerializerDeserializer[] serdes) throws HyracksDataException {
        int oldCurrentOff = this.currentOffsetForScan;
        int oldCurrentPageId = this.currentPageIxForScan;
        int oldCurrentElementIx = this.currentElementIxForScan;
        this.currentOffsetForScan = this.startOff - this.elementSize;
        this.currentPageIxForScan = 0;
        this.currentElementIxForScan = 0;
        StringBuilder strBuilder = new StringBuilder();
        while (this.hasNext()) {
            this.next();
            for (int i = 0; i < this.tuple.getFieldCount(); ++i) {
                ByteArrayInputStream inStream = new ByteArrayInputStream(this.tuple.getFieldData(i), this.tuple.getFieldStart(i), this.tuple.getFieldLength(i));
                DataInputStream dataIn = new DataInputStream(inStream);
                Object o = serdes[i].deserialize((DataInput)dataIn);
                strBuilder.append(o.toString());
                if (i + 1 >= this.tuple.getFieldCount()) continue;
                strBuilder.append(",");
            }
            strBuilder.append(" ");
        }
        this.currentOffsetForScan = oldCurrentOff;
        this.currentPageIxForScan = oldCurrentPageId;
        this.currentElementIxForScan = oldCurrentElementIx;
        return strBuilder.toString();
    }

    private int binarySearch(int[] arr, int arrStart, int arrLength, int key) {
        int begin = arrStart;
        int end = arrStart + arrLength - 1;
        while (begin <= end) {
            int mid = (begin + end) / 2;
            int cmp = key - arr[mid];
            if (cmp < 0) {
                end = mid - 1;
                continue;
            }
            if (cmp > 0) {
                begin = mid + 1;
                continue;
            }
            return mid;
        }
        if (begin > arr.length - 1) {
            return -1;
        }
        if (key < arr[begin]) {
            return begin;
        }
        return -1;
    }
}

