/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.dataflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LsmResource;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMInvertedIndexLocalResource
extends LsmResource {
    private static final long serialVersionUID = 1L;
    private final ITypeTraits[] tokenTypeTraits;
    private final IBinaryComparatorFactory[] tokenCmpFactories;
    private final IBinaryTokenizerFactory tokenizerFactory;
    private final boolean isPartitioned;
    private final int[] invertedIndexFields;
    private final int[] filterFieldsForNonBulkLoadOps;
    private final int[] invertedIndexFieldsForNonBulkLoadOps;
    private final double bloomFilterFalsePositiveRate;

    public LSMInvertedIndexLocalResource(String path, IStorageManager storageManager, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] filterFields, ILSMOperationTrackerFactory opTrackerProvider, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, IMetadataPageManagerFactory metadataPageManagerFactory, IVirtualBufferCacheProvider vbcProvider, ILSMIOOperationSchedulerProvider ioSchedulerProvider, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, boolean durable, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, IBinaryTokenizerFactory tokenizerFactory, boolean isPartitioned, int[] invertedIndexFields, int[] filterFieldsForNonBulkLoadOps, int[] invertedIndexFieldsForNonBulkLoadOps, double bloomFilterFalsePositiveRate) {
        super(path, storageManager, typeTraits, cmpFactories, filterTypeTraits, filterCmpFactories, filterFields, opTrackerProvider, ioOpCallbackFactory, pageWriteCallbackFactory, metadataPageManagerFactory, vbcProvider, ioSchedulerProvider, mergePolicyFactory, mergePolicyProperties, durable);
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.tokenizerFactory = tokenizerFactory;
        this.isPartitioned = isPartitioned;
        this.invertedIndexFields = invertedIndexFields;
        this.filterFieldsForNonBulkLoadOps = filterFieldsForNonBulkLoadOps;
        this.invertedIndexFieldsForNonBulkLoadOps = invertedIndexFieldsForNonBulkLoadOps;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
    }

    private LSMInvertedIndexLocalResource(IPersistedResourceRegistry registry, JsonNode json, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, IBinaryTokenizerFactory tokenizerFactory, boolean isPartitioned, int[] invertedIndexFields, int[] filterFieldsForNonBulkLoadOps, int[] invertedIndexFieldsForNonBulkLoadOps, double bloomFilterFalsePositiveRate) throws HyracksDataException {
        super(registry, json);
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.tokenizerFactory = tokenizerFactory;
        this.isPartitioned = isPartitioned;
        this.invertedIndexFields = invertedIndexFields;
        this.filterFieldsForNonBulkLoadOps = filterFieldsForNonBulkLoadOps;
        this.invertedIndexFieldsForNonBulkLoadOps = invertedIndexFieldsForNonBulkLoadOps;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
    }

    public ILSMIndex createInstance(INCServiceContext serviceCtx) throws HyracksDataException {
        IIOManager ioManager = serviceCtx.getIoManager();
        FileReference file = ioManager.resolve(this.path);
        List virtualBufferCaches = this.vbcProvider.getVirtualBufferCaches(serviceCtx, file);
        IBufferCache bufferCache = this.storageManager.getBufferCache(serviceCtx);
        ILSMMergePolicy mergePolicy = this.mergePolicyFactory.createMergePolicy(this.mergePolicyProperties, serviceCtx);
        ILSMIOOperationScheduler ioScheduler = this.ioSchedulerProvider.getIoScheduler(serviceCtx);
        this.ioOpCallbackFactory.initialize(serviceCtx, (IResource)this);
        this.pageWriteCallbackFactory.initialize(serviceCtx, (IResource)this);
        if (this.isPartitioned) {
            return InvertedIndexUtils.createPartitionedLSMInvertedIndex(ioManager, virtualBufferCaches, this.typeTraits, this.cmpFactories, this.tokenTypeTraits, this.tokenCmpFactories, this.tokenizerFactory, bufferCache, file.getAbsolutePath(), this.bloomFilterFalsePositiveRate, mergePolicy, this.opTrackerProvider.getOperationTracker(serviceCtx, (IResource)this), ioScheduler, this.ioOpCallbackFactory, this.pageWriteCallbackFactory, this.invertedIndexFields, this.filterTypeTraits, this.filterCmpFactories, this.filterFields, this.filterFieldsForNonBulkLoadOps, this.invertedIndexFieldsForNonBulkLoadOps, this.durable, (IPageManagerFactory)this.metadataPageManagerFactory, serviceCtx.getTracer());
        }
        return InvertedIndexUtils.createLSMInvertedIndex(ioManager, virtualBufferCaches, this.typeTraits, this.cmpFactories, this.tokenTypeTraits, this.tokenCmpFactories, this.tokenizerFactory, bufferCache, file.getAbsolutePath(), this.bloomFilterFalsePositiveRate, mergePolicy, this.opTrackerProvider.getOperationTracker(serviceCtx, (IResource)this), ioScheduler, this.ioOpCallbackFactory, this.pageWriteCallbackFactory, this.invertedIndexFields, this.filterTypeTraits, this.filterCmpFactories, this.filterFields, this.filterFieldsForNonBulkLoadOps, this.invertedIndexFieldsForNonBulkLoadOps, this.durable, this.metadataPageManagerFactory, serviceCtx.getTracer());
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode jsonObject = registry.getClassIdentifier(((Object)((Object)this)).getClass(), 1L);
        super.appendToJson(jsonObject, registry);
        ArrayNode tokenTypeTraitsArray = OBJECT_MAPPER.createArrayNode();
        for (ITypeTraits tt : this.tokenTypeTraits) {
            tokenTypeTraitsArray.add(tt.toJson(registry));
        }
        jsonObject.set("tokenTypeTraits", (JsonNode)tokenTypeTraitsArray);
        ArrayNode tokenCmpFactoriesArray = OBJECT_MAPPER.createArrayNode();
        for (IBinaryComparatorFactory factory : this.tokenCmpFactories) {
            tokenCmpFactoriesArray.add(factory.toJson(registry));
        }
        jsonObject.set("tokenCmpFactories", (JsonNode)tokenCmpFactoriesArray);
        jsonObject.set("tokenizerFactory", this.tokenizerFactory.toJson(registry));
        jsonObject.put("isPartitioned", this.isPartitioned);
        jsonObject.putPOJO("invertedIndexFields", (Object)this.invertedIndexFields);
        jsonObject.putPOJO("filterFieldsForNonBulkLoadOps", (Object)this.filterFieldsForNonBulkLoadOps);
        jsonObject.putPOJO("invertedIndexFieldsForNonBulkLoadOps", (Object)this.invertedIndexFieldsForNonBulkLoadOps);
        jsonObject.putPOJO("bloomFilterFalsePositiveRate", (Object)this.bloomFilterFalsePositiveRate);
        return jsonObject;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        ArrayList<ITypeTraits> tokenTypeTraitsList = new ArrayList<ITypeTraits>();
        ArrayNode jsonTokenTypeTraits = (ArrayNode)json.get("tokenTypeTraits");
        for (JsonNode tt : jsonTokenTypeTraits) {
            tokenTypeTraitsList.add((ITypeTraits)registry.deserialize(tt));
        }
        ITypeTraits[] tokenTypeTraits = tokenTypeTraitsList.toArray(new ITypeTraits[0]);
        ArrayList<IBinaryComparatorFactory> tokenCmpFactoriesList = new ArrayList<IBinaryComparatorFactory>();
        ArrayNode jsontokenCmpFactories = (ArrayNode)json.get("tokenCmpFactories");
        for (JsonNode cf : jsontokenCmpFactories) {
            tokenCmpFactoriesList.add((IBinaryComparatorFactory)registry.deserialize(cf));
        }
        IBinaryComparatorFactory[] tokenCmpFactories = tokenCmpFactoriesList.toArray(new IBinaryComparatorFactory[0]);
        IBinaryTokenizerFactory tokenizerFactory = (IBinaryTokenizerFactory)registry.deserialize(json.get("tokenizerFactory"));
        boolean isPartitioned = json.get("isPartitioned").asBoolean();
        int[] invertedIndexFields = (int[])OBJECT_MAPPER.convertValue((Object)json.get("invertedIndexFields"), int[].class);
        int[] filterFieldsForNonBulkLoadOps = (int[])OBJECT_MAPPER.convertValue((Object)json.get("filterFieldsForNonBulkLoadOps"), int[].class);
        int[] invertedIndexFieldsForNonBulkLoadOps = (int[])OBJECT_MAPPER.convertValue((Object)json.get("invertedIndexFieldsForNonBulkLoadOps"), int[].class);
        double bloomFilterFalsePositiveRate = json.get("bloomFilterFalsePositiveRate").asDouble();
        return new LSMInvertedIndexLocalResource(registry, json, tokenTypeTraits, tokenCmpFactories, tokenizerFactory, isPartitioned, invertedIndexFields, filterFieldsForNonBulkLoadOps, invertedIndexFieldsForNonBulkLoadOps, bloomFilterFalsePositiveRate);
    }
}

