/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushSubplanIntoGroupByRule
implements IAlgebraicRewriteRule {
    private Mutable<ILogicalOperator> rootRef;
    private boolean invoked = false;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (!this.invoked) {
            this.rootRef = opRef;
            this.invoked = true;
        }
        return this.rewriteForOperator(this.rootRef, opRef, context);
    }

    private boolean rewriteForOperator(Mutable<ILogicalOperator> rootRef, Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean changed = false;
        ILogicalOperator parentOperator = (ILogicalOperator)opRef.getValue();
        for (Mutable ref : parentOperator.getInputs()) {
            ILogicalOperator op = (ILogicalOperator)ref.getValue();
            ArrayDeque<SubplanOperator> subplans = new ArrayDeque<SubplanOperator>();
            if (op.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
                changed |= this.rewriteForOperator(rootRef, (Mutable<ILogicalOperator>)ref, context);
                continue;
            }
            while (op.getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
                SubplanOperator currentSubplan = (SubplanOperator)op;
                for (ILogicalPlan subplan : currentSubplan.getNestedPlans()) {
                    for (Mutable nestedRootRef : subplan.getRoots()) {
                        changed |= this.rewriteForOperator((Mutable<ILogicalOperator>)nestedRootRef, (Mutable<ILogicalOperator>)nestedRootRef, context);
                    }
                }
                subplans.addFirst(currentSubplan);
                op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
            }
            if (op.getOperatorTag() != LogicalOperatorTag.GROUP) continue;
            GroupByOperator gby = (GroupByOperator)op;
            for (ILogicalPlan subplan : gby.getNestedPlans()) {
                for (Mutable nestedRootRef : subplan.getRoots()) {
                    changed |= this.rewriteForOperator((Mutable<ILogicalOperator>)nestedRootRef, (Mutable<ILogicalOperator>)nestedRootRef, context);
                }
            }
            changed |= this.pushSubplansIntoGroupBy(rootRef, parentOperator, subplans, gby, context);
        }
        return changed;
    }

    private boolean pushSubplansIntoGroupBy(Mutable<ILogicalOperator> currentRootRef, ILogicalOperator parentOperator, Deque<SubplanOperator> subplans, GroupByOperator gby, IOptimizationContext context) throws AlgebricksException {
        boolean changed = false;
        ArrayList<Object> newGbyNestedPlans = new ArrayList<Object>();
        List originalNestedPlansInGby = gby.getNestedPlans();
        for (ILogicalPlan gbyNestedPlanOriginal : originalNestedPlansInGby) {
            newGbyNestedPlans.add(gbyNestedPlanOriginal);
        }
        Iterator<SubplanOperator> subplanOperatorIterator = subplans.iterator();
        while (subplanOperatorIterator.hasNext()) {
            SubplanOperator subplan = subplanOperatorIterator.next();
            Iterator subplanNestedPlanIterator = subplan.getNestedPlans().iterator();
            while (subplanNestedPlanIterator.hasNext()) {
                ILogicalPlan subplanNestedPlan = (ILogicalPlan)subplanNestedPlanIterator.next();
                List upperSubplanRootRefs = subplanNestedPlan.getRoots();
                Iterator upperSubplanRootRefIterator = upperSubplanRootRefs.iterator();
                while (upperSubplanRootRefIterator.hasNext()) {
                    Mutable rootOpRef = (Mutable)upperSubplanRootRefIterator.next();
                    if (this.downToNts((Mutable<ILogicalOperator>)rootOpRef) == null) continue;
                    ListSet freeVars = new ListSet();
                    OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc((AbstractLogicalOperator)((AbstractLogicalOperator)rootOpRef.getValue()), (Set)freeVars);
                    block4: for (ILogicalPlan gbyNestedPlanOriginal : originalNestedPlansInGby) {
                        ILogicalPlan gbyNestedPlan = OperatorManipulationUtil.deepCopy((ILogicalPlan)gbyNestedPlanOriginal, (IOptimizationContext)context);
                        List gbyRootOpRefs = gbyNestedPlan.getRoots();
                        for (int rootIndex = 0; rootIndex < gbyRootOpRefs.size(); ++rootIndex) {
                            Mutable originalGbyRootOpRef = (Mutable)gbyNestedPlan.getRoots().get(rootIndex);
                            Mutable<ILogicalOperator> originalGbyNtsRef = this.downToNts((Mutable<ILogicalOperator>)originalGbyRootOpRef);
                            if (originalGbyNtsRef == null) continue;
                            NestedTupleSourceOperator originalNts = (NestedTupleSourceOperator)originalGbyNtsRef.getValue();
                            originalNts.setDataSourceReference((Mutable)new MutableObject((Object)gby));
                            Mutable gbyRootOpRef = (Mutable)gbyRootOpRefs.get(rootIndex);
                            ListSet liveVars = new ListSet();
                            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)gbyRootOpRef.getValue()), (Collection)liveVars);
                            if (!liveVars.containsAll((Collection<?>)freeVars)) continue;
                            AggregateOperator aggOp = (AggregateOperator)gbyRootOpRef.getValue();
                            for (int varIndex = aggOp.getVariables().size() - 1; varIndex >= 0; --varIndex) {
                                if (freeVars.contains(aggOp.getVariables().get(varIndex))) continue;
                                aggOp.getVariables().remove(varIndex);
                                aggOp.getExpressions().remove(varIndex);
                            }
                            Pair copiedAggOpAndVarMap = OperatorManipulationUtil.deepCopyWithNewVars((ILogicalOperator)aggOp, (IOptimizationContext)context);
                            ILogicalOperator newBottomAgg = (ILogicalOperator)copiedAggOpAndVarMap.first;
                            VariableUtilities.substituteVariablesInDescendantsAndSelf((ILogicalOperator)((ILogicalOperator)rootOpRef.getValue()), (Map)((Map)copiedAggOpAndVarMap.second), (ITypingContext)context);
                            Mutable<ILogicalOperator> ntsRef = this.downToNts((Mutable<ILogicalOperator>)rootOpRef);
                            ntsRef.setValue((Object)newBottomAgg);
                            gbyRootOpRef.setValue(rootOpRef.getValue());
                            Mutable<ILogicalOperator> oldGbyNtsRef = this.downToNts((Mutable<ILogicalOperator>)new MutableObject((Object)newBottomAgg));
                            NestedTupleSourceOperator nts = (NestedTupleSourceOperator)oldGbyNtsRef.getValue();
                            nts.setDataSourceReference((Mutable)new MutableObject((Object)gby));
                            OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)((ILogicalOperator)rootOpRef.getValue()), (ITypingContext)context);
                            newGbyNestedPlans.add(new ALogicalPlanImpl(rootOpRef));
                            upperSubplanRootRefIterator.remove();
                            changed = true;
                            continue block4;
                        }
                    }
                }
                if (!upperSubplanRootRefs.isEmpty()) continue;
                subplanNestedPlanIterator.remove();
                changed = true;
            }
            if (!subplan.getNestedPlans().isEmpty()) continue;
            subplanOperatorIterator.remove();
            changed = true;
        }
        gby.getNestedPlans().clear();
        gby.getNestedPlans().addAll(newGbyNestedPlans);
        ILogicalOperator parent = !subplans.isEmpty() ? (ILogicalOperator)subplans.getFirst() : parentOperator;
        ((Mutable)parent.getInputs().get(0)).setValue((Object)gby);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)gby);
        context.computeAndSetTypeEnvironmentForOperator(parent);
        return changed |= this.cleanup((ILogicalOperator)currentRootRef.getValue(), gby);
    }

    private boolean cleanup(ILogicalOperator rootOp, GroupByOperator gby) throws AlgebricksException {
        boolean changed = false;
        HashSet freeVars = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInPath((ILogicalOperator)rootOp, (ILogicalOperator)gby, freeVars);
        Iterator nestedPlanIterator = gby.getNestedPlans().iterator();
        while (nestedPlanIterator.hasNext()) {
            ILogicalPlan nestedPlan = (ILogicalPlan)nestedPlanIterator.next();
            Iterator nestRootRefIterator = nestedPlan.getRoots().iterator();
            while (nestRootRefIterator.hasNext()) {
                Mutable nestRootRef = (Mutable)nestRootRefIterator.next();
                AggregateOperator aggOp = (AggregateOperator)nestRootRef.getValue();
                for (int varIndex = aggOp.getVariables().size() - 1; varIndex >= 0; --varIndex) {
                    if (freeVars.contains(aggOp.getVariables().get(varIndex))) continue;
                    aggOp.getVariables().remove(varIndex);
                    aggOp.getExpressions().remove(varIndex);
                    changed = true;
                }
                if (!aggOp.getVariables().isEmpty()) continue;
                nestRootRefIterator.remove();
                changed = true;
            }
            if (!nestedPlan.getRoots().isEmpty()) continue;
            nestedPlanIterator.remove();
            changed = true;
        }
        return changed;
    }

    private Mutable<ILogicalOperator> downToNts(Mutable<ILogicalOperator> opRef) {
        Mutable leafOp;
        List leafOps = OperatorManipulationUtil.findLeafDescendantsOrSelf(opRef);
        if (leafOps.size() == 1 && ((ILogicalOperator)(leafOp = (Mutable)leafOps.get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return leafOp;
        }
        return null;
    }
}

