/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.rewriter.rules.subplan.ReplaceNtsWithSubplanInputOperatorVisitor;

public class EliminateSubplanWithInputCardinalityOneRule
implements IAlgebraicRewriteRule {
    private Mutable<ILogicalOperator> rootRef;
    private boolean invoked = false;

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (!this.invoked) {
            this.rootRef = opRef;
            this.invoked = true;
        }
        return this.rewriteForOperator(this.rootRef, opRef, context);
    }

    private boolean rewriteForOperator(Mutable<ILogicalOperator> rootRef, Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getInputs().size() <= 0) {
            return false;
        }
        boolean changed = false;
        for (Mutable currentOpRef : op.getInputs()) {
            ILogicalPlan plan;
            List rootRefs;
            AbstractLogicalOperator op1 = (AbstractLogicalOperator)currentOpRef.getValue();
            if (op1.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
                changed |= this.rewriteForOperator(rootRef, (Mutable<ILogicalOperator>)currentOpRef, context);
                continue;
            }
            SubplanOperator subplan = (SubplanOperator)op1;
            ListSet usedVarsUp = new ListSet();
            OperatorPropertiesUtil.getFreeVariablesInPath((ILogicalOperator)((ILogicalOperator)rootRef.getValue()), (ILogicalOperator)subplan, (Set)usedVarsUp);
            if (subplan.getNestedPlans().size() != 1) continue;
            for (Mutable nestedRootRef : ((ILogicalPlan)subplan.getNestedPlans().get(0)).getRoots()) {
                changed |= this.rewriteForOperator((Mutable<ILogicalOperator>)nestedRootRef, (Mutable<ILogicalOperator>)nestedRootRef, context);
            }
            ILogicalOperator subplanInputOperator = (ILogicalOperator)((Mutable)subplan.getInputs().get(0)).getValue();
            ListSet subplanInputVars = new ListSet();
            VariableUtilities.getLiveVariables((ILogicalOperator)subplanInputOperator, (Collection)subplanInputVars);
            int subplanInputVarSize = subplanInputVars.size();
            subplanInputVars.removeAll((Collection<?>)usedVarsUp);
            if (subplanInputVars.size() < subplanInputVarSize) continue;
            ListSet freeVars = new ListSet();
            OperatorPropertiesUtil.getFreeVariablesInSubplans((AbstractOperatorWithNestedPlans)subplan, (Set)freeVars);
            boolean cardinalityOne = this.isCardinalityOne((Mutable<ILogicalOperator>)((Mutable)subplan.getInputs().get(0)), (Set<LogicalVariable>)freeVars);
            if (!cardinalityOne || (rootRefs = (plan = (ILogicalPlan)subplan.getNestedPlans().get(0)).getRoots()).size() != 1) continue;
            ILogicalOperator topOperator = (ILogicalOperator)((Mutable)rootRefs.get(0)).getValue();
            ReplaceNtsWithSubplanInputOperatorVisitor visitor = new ReplaceNtsWithSubplanInputOperatorVisitor(context, (ILogicalOperator)subplan);
            ILogicalOperator newTopOperator = (ILogicalOperator)topOperator.accept((ILogicalOperatorVisitor)visitor, null);
            currentOpRef.setValue((Object)newTopOperator);
            OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)newTopOperator, (ITypingContext)context);
            changed = true;
        }
        return changed;
    }

    private boolean isCardinalityOne(Mutable<ILogicalOperator> opRef, Set<LogicalVariable> freeVars) throws AlgebricksException {
        ListSet varsWithCardinalityOne = new ListSet();
        ListSet varsLiveAtUnnestAndJoin = new ListSet();
        this.isCardinalityOne(opRef, freeVars, (Set<LogicalVariable>)varsWithCardinalityOne, (Set<LogicalVariable>)varsLiveAtUnnestAndJoin);
        varsWithCardinalityOne.removeAll((Collection<?>)varsLiveAtUnnestAndJoin);
        return varsWithCardinalityOne.equals(freeVars);
    }

    private void isCardinalityOne(Mutable<ILogicalOperator> opRef, Set<LogicalVariable> freeVars, Set<LogicalVariable> varsWithCardinalityOne, Set<LogicalVariable> varsLiveAtUnnestAndJoin) throws AlgebricksException {
        AbstractLogicalOperator operator = (AbstractLogicalOperator)opRef.getValue();
        ArrayList liveVars = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)operator, liveVars);
        if (OperatorPropertiesUtil.isCardinalityZeroOrOne((ILogicalOperator)operator)) {
            for (LogicalVariable liveVar : liveVars) {
                if (!freeVars.contains(liveVar)) continue;
                varsWithCardinalityOne.add(liveVar);
            }
        } else if (operator.getOperatorTag() == LogicalOperatorTag.UNNEST || operator.getOperatorTag() == LogicalOperatorTag.INNERJOIN || operator.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) {
            VariableUtilities.getLiveVariables((ILogicalOperator)operator, varsLiveAtUnnestAndJoin);
        }
    }
}

