/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.impls.AbstractSearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class RangePredicate
extends AbstractSearchPredicate {
    private static final long serialVersionUID = 1L;
    protected ITupleReference lowKey = null;
    protected ITupleReference highKey = null;
    protected boolean lowKeyInclusive = true;
    protected boolean highKeyInclusive = true;
    protected MultiComparator lowKeyCmp;
    protected MultiComparator highKeyCmp;

    public RangePredicate() {
    }

    public RangePredicate(ITupleReference lowKey, ITupleReference highKey, boolean lowKeyInclusive, boolean highKeyInclusive, MultiComparator lowKeyCmp, MultiComparator highKeyCmp) {
        this.lowKey = lowKey;
        this.highKey = highKey;
        this.lowKeyInclusive = lowKeyInclusive;
        this.highKeyInclusive = highKeyInclusive;
        this.lowKeyCmp = lowKeyCmp;
        this.highKeyCmp = highKeyCmp;
    }

    public RangePredicate(ITupleReference lowKey, ITupleReference highKey, boolean lowKeyInclusive, boolean highKeyInclusive, MultiComparator lowKeyCmp, MultiComparator highKeyCmp, ITupleReference minFilterTuple, ITupleReference maxFilterTuple) {
        super(minFilterTuple, maxFilterTuple);
        this.lowKey = lowKey;
        this.highKey = highKey;
        this.lowKeyInclusive = lowKeyInclusive;
        this.highKeyInclusive = highKeyInclusive;
        this.lowKeyCmp = lowKeyCmp;
        this.highKeyCmp = highKeyCmp;
    }

    public void reset(ITupleReference lowKey, ITupleReference highKey, boolean lowKeyInclusive, boolean highKeyInclusive, MultiComparator lowKeyCmp, MultiComparator highKeyCmp) {
        this.lowKey = lowKey;
        this.highKey = highKey;
        this.lowKeyInclusive = lowKeyInclusive;
        this.highKeyInclusive = highKeyInclusive;
        this.lowKeyCmp = lowKeyCmp;
        this.highKeyCmp = highKeyCmp;
    }

    public MultiComparator getLowKeyComparator() {
        return this.lowKeyCmp;
    }

    public MultiComparator getHighKeyComparator() {
        return this.highKeyCmp;
    }

    public void setLowKeyComparator(MultiComparator lowKeyCmp) {
        this.lowKeyCmp = lowKeyCmp;
    }

    public void setHighKeyComparator(MultiComparator highKeyCmp) {
        this.highKeyCmp = highKeyCmp;
    }

    public ITupleReference getLowKey() {
        return this.lowKey;
    }

    public ITupleReference getHighKey() {
        return this.highKey;
    }

    public void setLowKey(ITupleReference lowKey, boolean lowKeyInclusive) {
        this.lowKey = lowKey;
        this.lowKeyInclusive = lowKeyInclusive;
    }

    public void setHighKey(ITupleReference highKey, boolean highKeyInclusive) {
        this.highKey = highKey;
        this.highKeyInclusive = highKeyInclusive;
    }

    public boolean isLowKeyInclusive() {
        return this.lowKeyInclusive;
    }

    public boolean isHighKeyInclusive() {
        return this.highKeyInclusive;
    }

    public void setLowKey(ITupleReference lowKey) {
        this.lowKey = lowKey;
    }

    public void setHighKey(ITupleReference highKey) {
        this.highKey = highKey;
    }

    public void setLowKeyCmp(MultiComparator lowKeyCmp) {
        this.lowKeyCmp = lowKeyCmp;
    }

    public void setHighKeyCmp(MultiComparator highKeyCmp) {
        this.highKeyCmp = highKeyCmp;
    }

    public boolean isPointPredicate(MultiComparator originalKeyComparator) throws HyracksDataException {
        if (this.getLowKey() == null) {
            return false;
        }
        if (this.getHighKey() == null) {
            return false;
        }
        if (!this.isLowKeyInclusive()) {
            return false;
        }
        if (!this.isHighKeyInclusive()) {
            return false;
        }
        if (this.getLowKeyComparator().getKeyFieldCount() != this.getHighKeyComparator().getKeyFieldCount()) {
            return false;
        }
        if (this.getLowKeyComparator().getKeyFieldCount() != originalKeyComparator.getKeyFieldCount()) {
            return false;
        }
        return originalKeyComparator.compare(this.getLowKey(), this.getHighKey()) == 0;
    }
}

