/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.asterix.geo.evaluators.functions.AbstractSTSingleGeometryDescriptor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class STNPointsDescriptor
extends AbstractSTSingleGeometryDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new STNPointsDescriptor();
        }
    };

    @Override
    protected Object evaluateOGCGeometry(OGCGeometry geometry) throws HyracksDataException {
        Geometry esriGeometry = geometry.getEsriGeometry();
        if (esriGeometry instanceof MultiVertexGeometry) {
            return ((MultiVertexGeometry)esriGeometry).getPointCount();
        }
        if (esriGeometry instanceof Point) {
            return 1;
        }
        if (esriGeometry == null) {
            int count = 0;
            GeometryCursor geometryCursor = geometry.getEsriGeometryCursor();
            esriGeometry = geometryCursor.next();
            while (esriGeometry != null) {
                if (esriGeometry instanceof MultiVertexGeometry) {
                    count += ((MultiVertexGeometry)esriGeometry).getPointCount();
                } else if (esriGeometry instanceof Point) {
                    ++count;
                }
                esriGeometry = geometryCursor.next();
            }
            return count;
        }
        if (geometry.isEmpty()) {
            return 0;
        }
        throw new UnsupportedOperationException("The operation " + this.getIdentifier() + " is not supported for the type " + geometry.geometryType());
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_N_POINTS;
    }
}

