/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.message;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.runtime.message.TxnIdBlockResponse;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TxnIdBlockRequest
implements ICcAddressedMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int BLOCK_SIZE = 512;
    private static final long serialVersionUID = 1L;
    private static BlockingQueue<TxnIdBlockResponse> blockQueue = new LinkedBlockingQueue<TxnIdBlockResponse>();
    private final String nodeId;
    private final int blockSizeRequested;

    public TxnIdBlockRequest(String nodeId, int blockSizeRequested) {
        this.nodeId = nodeId;
        this.blockSizeRequested = blockSizeRequested;
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException {
        try {
            ICCMessageBroker broker = (ICCMessageBroker)appCtx.getServiceContext().getMessageBroker();
            long startingId = appCtx.getTxnIdFactory().getIdBlock(this.blockSizeRequested);
            TxnIdBlockResponse response = new TxnIdBlockResponse(startingId, this.blockSizeRequested);
            broker.sendApplicationMessageToNC((INcAddressedMessage)response, this.nodeId);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static Block send(INcApplicationContext ncs) throws HyracksDataException {
        TxnIdBlockRequest blockRequestMessage = new TxnIdBlockRequest(ncs.getServiceContext().getNodeId(), 512);
        try {
            ((INCMessageBroker)ncs.getServiceContext().getMessageBroker()).sendMessageToPrimaryCC((ICcAddressedMessage)blockRequestMessage);
            TxnIdBlockResponse response = blockQueue.take();
            return new Block(response.getStartingId(), response.getBlockSize());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Unable to request transaction id block", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    static void addResponse(TxnIdBlockResponse response) {
        blockQueue.offer(response);
    }

    public String toString() {
        return TxnIdBlockRequest.class.getSimpleName();
    }

    public static class Block {
        private final long startingId;
        private final int blockSize;

        public Block(long startingId, int blockSize) {
            this.startingId = startingId;
            this.blockSize = blockSize;
        }

        public long getStartingId() {
            return this.startingId;
        }

        public int getBlockSize() {
            return this.blockSize;
        }
    }
}

