/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.job.listener;

import org.apache.asterix.common.api.IJobEventListenerFactory;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.TransactionOptions;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.job.IJobletEventListener;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.JobParameterByteStore;
import org.apache.hyracks.api.job.JobStatus;

public class JobEventListenerFactory
implements IJobEventListenerFactory {
    private static final long serialVersionUID = 1L;
    private TxnId txnId;
    private final boolean transactionalWrite;
    private static final byte[] TRANSACTION_ID_PARAMETER_NAME = "TxnIdParameter".getBytes();

    public JobEventListenerFactory(TxnId txnId, boolean transactionalWrite) {
        this.txnId = txnId;
        this.transactionalWrite = transactionalWrite;
    }

    public TxnId getTxnId(int datasetId) {
        return this.txnId;
    }

    public IJobletEventListenerFactory copyFactory() {
        return new JobEventListenerFactory(this.txnId, this.transactionalWrite);
    }

    public void updateListenerJobParameters(JobParameterByteStore jobParameterByteStore) {
        String AsterixTransactionIdString = new String(jobParameterByteStore.getParameterValue(TRANSACTION_ID_PARAMETER_NAME, 0, TRANSACTION_ID_PARAMETER_NAME.length));
        if (AsterixTransactionIdString.length() > 0) {
            this.txnId = new TxnId((long)Integer.parseInt(AsterixTransactionIdString));
        }
    }

    public IJobletEventListener createListener(final IHyracksJobletContext jobletContext) {
        return new IJobletEventListener(){

            public void jobletFinish(JobStatus jobStatus) {
                try {
                    ITransactionManager txnManager = ((INcApplicationContext)jobletContext.getServiceContext().getApplicationContext()).getTransactionSubsystem().getTransactionManager();
                    ITransactionContext txnContext = txnManager.getTransactionContext(JobEventListenerFactory.this.txnId);
                    txnContext.setWriteTxn(JobEventListenerFactory.this.transactionalWrite);
                    if (jobStatus != JobStatus.FAILURE) {
                        txnManager.commitTransaction(JobEventListenerFactory.this.txnId);
                    } else {
                        txnManager.abortTransaction(JobEventListenerFactory.this.txnId);
                    }
                }
                catch (ACIDException e) {
                    throw new Error(e);
                }
            }

            public void jobletStart() {
                try {
                    TransactionOptions options = new TransactionOptions(ITransactionManager.AtomicityLevel.ENTITY_LEVEL);
                    ((INcApplicationContext)jobletContext.getServiceContext().getApplicationContext()).getTransactionSubsystem().getTransactionManager().beginTransaction(JobEventListenerFactory.this.txnId, options);
                }
                catch (ACIDException e) {
                    throw new Error(e);
                }
            }
        };
    }
}

