/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.binary;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.binary.AbstractBinaryScalarEvaluator;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class BinaryLengthDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new BinaryLengthDescriptor();
        }
    };
    private static final ATypeTag[] EXPECTED_TAGS = new ATypeTag[]{ATypeTag.BINARY};

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractBinaryScalarEvaluator(ctx, args, BinaryLengthDescriptor.this.getIdentifier(), BinaryLengthDescriptor.this.sourceLoc){
                    private AMutableInt64 result;
                    private ISerializerDeserializer<AInt64> intSerde;
                    {
                        this.result = new AMutableInt64(0L);
                        this.intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.evaluators[0].evaluate(tuple, this.pointables[0]);
                        if (PointableHelper.checkAndSetMissingOrNull(resultPointable, this.pointables[0])) {
                            return;
                        }
                        ATypeTag tag = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[0].getByteArray()[this.pointables[0].getStartOffset()]];
                        this.checkTypeMachingThrowsIfNot(EXPECTED_TAGS, tag);
                        int len = ByteArrayPointable.getContentLength((byte[])this.pointables[0].getByteArray(), (int)(this.pointables[0].getStartOffset() + 1));
                        this.result.setValue((long)len);
                        this.intSerde.serialize((Object)this.result, this.dataOutput);
                        resultPointable.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.BINARY_LENGTH;
    }
}

