/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class PointableHelper {
    private static final byte[] NULL_BYTES = new byte[]{ATypeTag.SERIALIZED_NULL_TYPE_TAG};
    private static final byte[] MISSING_BYTES = new byte[]{ATypeTag.SERIALIZED_MISSING_TYPE_TAG};
    private final UTF8StringWriter utf8Writer = new UTF8StringWriter();
    public static final IPointable NULL_REF = new VoidPointable();

    public static int compareStringBinValues(IValueReference a, IValueReference b, IBinaryComparator comparator) throws HyracksDataException {
        return comparator.compare(a.getByteArray(), a.getStartOffset() + 1, a.getLength() - 1, b.getByteArray(), b.getStartOffset() + 1, b.getLength() - 1);
    }

    public static boolean isEqual(IValueReference a, IValueReference b, IBinaryComparator comparator) throws HyracksDataException {
        return PointableHelper.compareStringBinValues(a, b, comparator) == 0;
    }

    public static boolean byteArrayEqual(IValueReference valueRef1, IValueReference valueRef2) {
        return PointableHelper.byteArrayEqual(valueRef1, valueRef2, 3);
    }

    public static boolean byteArrayEqual(IValueReference valueRef1, IValueReference valueRef2, int dataOffset) {
        int length2;
        if (valueRef1 == null || valueRef2 == null) {
            return false;
        }
        if (valueRef1 == valueRef2) {
            return true;
        }
        int length1 = valueRef1.getLength();
        if (length1 != (length2 = valueRef2.getLength())) {
            return false;
        }
        byte[] bytes1 = valueRef1.getByteArray();
        byte[] bytes2 = valueRef2.getByteArray();
        int start1 = valueRef1.getStartOffset() + dataOffset;
        int start2 = valueRef2.getStartOffset() + dataOffset;
        int end = start1 + length1 - dataOffset;
        int i = start1;
        int j = start2;
        while (i < end) {
            if (bytes1[i] != bytes2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean sameType(ATypeTag typeTag, IVisitablePointable visitablePointable) {
        return PointableHelper.getTypeTag((IValueReference)visitablePointable) == typeTag;
    }

    public static ATypeTag getTypeTag(IValueReference visitablePointable) {
        byte[] bytes = visitablePointable.getByteArray();
        int s = visitablePointable.getStartOffset();
        return (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[s]);
    }

    public static <T extends IValueReference> T findItem(IValueReference item, Collection<T> list, IBinaryComparator comparator) throws HyracksDataException {
        for (IValueReference listItem : list) {
            if (comparator.compare(item.getByteArray(), item.getStartOffset(), item.getLength(), listItem.getByteArray(), listItem.getStartOffset(), listItem.getLength()) != 0) continue;
            return (T)listItem;
        }
        return null;
    }

    public void serializeString(String str, IMutableValueStorage vs, boolean writeTag) throws HyracksDataException {
        vs.reset();
        try {
            DataOutput output = vs.getDataOutput();
            if (writeTag) {
                output.write(ATypeTag.STRING.serialize());
            }
            this.utf8Writer.writeUTF8((CharSequence)str, output);
        }
        catch (IOException e) {
            throw new HyracksDataException("Could not serialize " + LogRedactionUtil.userData((String)str));
        }
    }

    public static void setNull(IPointable pointable) {
        pointable.set(NULL_BYTES, 0, NULL_BYTES.length);
    }

    public static void setMissing(IPointable pointable) {
        pointable.set(MISSING_BYTES, 0, MISSING_BYTES.length);
    }

    public static boolean checkAndSetMissingOrNull(IPointable result, IPointable pointable1) throws HyracksDataException {
        return PointableHelper.checkAndSetMissingOrNull(result, null, pointable1, null, null, null);
    }

    public static boolean checkAndSetMissingOrNull(IPointable result, IPointable pointable1, IPointable pointable2) throws HyracksDataException {
        return PointableHelper.checkAndSetMissingOrNull(result, null, pointable1, pointable2, null, null);
    }

    public static boolean checkAndSetMissingOrNull(IPointable result, IPointable pointable1, IPointable pointable2, IPointable pointable3) throws HyracksDataException {
        return PointableHelper.checkAndSetMissingOrNull(result, null, pointable1, pointable2, pointable3, null);
    }

    public static boolean checkAndSetMissingOrNull(IPointable result, IPointable pointable1, IPointable pointable2, IPointable pointable3, IPointable pointable4) throws HyracksDataException {
        return PointableHelper.checkAndSetMissingOrNull(result, null, pointable1, pointable2, pointable3, pointable4);
    }

    public static boolean checkAndSetMissingOrNull(IPointable result, ListAccessor listAccessor, IPointable pointable1) throws HyracksDataException {
        return PointableHelper.checkAndSetMissingOrNull(result, listAccessor, pointable1, null, null, null);
    }

    public static boolean checkAndSetMissingOrNull(IPointable result, ListAccessor listAccessor, IPointable pointable1, IPointable pointable2) throws HyracksDataException {
        return PointableHelper.checkAndSetMissingOrNull(result, listAccessor, pointable1, pointable2, null, null);
    }

    public static boolean checkAndSetMissingOrNull(IPointable result, ListAccessor listAccessor, IPointable pointable1, IPointable pointable2, IPointable pointable3) throws HyracksDataException {
        return PointableHelper.checkAndSetMissingOrNull(result, listAccessor, pointable1, pointable2, pointable3, null);
    }

    public static boolean checkAndSetMissingOrNull(IPointable result, ListAccessor listAccessor, IPointable pointable1, IPointable pointable2, IPointable pointable3, IPointable pointable4) throws HyracksDataException {
        boolean isMeetNull = false;
        switch (PointableHelper.getPointableValueState(pointable1, listAccessor)) {
            case MISSING: {
                PointableHelper.setMissing(result);
                return true;
            }
            case NULL: {
                isMeetNull = true;
            }
        }
        if (pointable2 != null) {
            switch (PointableHelper.getPointableValueState(pointable2, listAccessor)) {
                case MISSING: {
                    PointableHelper.setMissing(result);
                    return true;
                }
                case NULL: {
                    isMeetNull = true;
                }
            }
        }
        if (pointable3 != null) {
            switch (PointableHelper.getPointableValueState(pointable3, listAccessor)) {
                case MISSING: {
                    PointableHelper.setMissing(result);
                    return true;
                }
                case NULL: {
                    isMeetNull = true;
                }
            }
        }
        if (pointable4 != null) {
            switch (PointableHelper.getPointableValueState(pointable4, listAccessor)) {
                case MISSING: {
                    PointableHelper.setMissing(result);
                    return true;
                }
                case NULL: {
                    isMeetNull = true;
                }
            }
        }
        if (isMeetNull) {
            PointableHelper.setNull(result);
            return true;
        }
        return false;
    }

    private static PointableValueState getPointableValueState(IPointable pointable, ListAccessor listAccessor) throws HyracksDataException {
        int offset;
        if (pointable.getLength() == 0) {
            return PointableValueState.EMPTY_POINTABLE;
        }
        byte[] bytes = pointable.getByteArray();
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset = pointable.getStartOffset()]);
        if (typeTag == ATypeTag.MISSING) {
            return PointableValueState.MISSING;
        }
        if (typeTag == ATypeTag.NULL) {
            return PointableValueState.NULL;
        }
        boolean isNull = false;
        if (listAccessor != null && typeTag.isListType()) {
            listAccessor.reset(bytes, offset);
            for (int i = 0; i < listAccessor.size(); ++i) {
                if (listAccessor.getItemType(listAccessor.getItemOffset(i)) == ATypeTag.MISSING) {
                    return PointableValueState.MISSING;
                }
                if (listAccessor.getItemType(listAccessor.getItemOffset(i)) != ATypeTag.NULL) continue;
                isNull = true;
            }
        }
        if (isNull) {
            return PointableValueState.NULL;
        }
        return PointableValueState.PRESENT;
    }

    public static boolean isValidLongValue(byte[] bytes, int startOffset, boolean acceptFloatAndDouble) {
        float value;
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        if (!acceptFloatAndDouble) {
            return ATypeHierarchy.canPromote((ATypeTag)typeTag, (ATypeTag)ATypeTag.BIGINT);
        }
        if (!ATypeHierarchy.canPromote((ATypeTag)typeTag, (ATypeTag)ATypeTag.DOUBLE)) {
            return false;
        }
        if (typeTag == ATypeTag.FLOAT && ((value = AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)(startOffset + 1))) > 9.223372E18f || value < -9.223372E18f || (double)value > Math.floor(value) || Float.isNaN(value))) {
            return false;
        }
        return typeTag != ATypeTag.DOUBLE || !((value = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + 1))) > 9.223372036854776E18 || value < -9.223372036854776E18 || value > Math.floor(value)) && !Double.isNaN(value);
    }

    static {
        NULL_REF.set(NULL_BYTES, 0, NULL_BYTES.length);
    }

    private static enum PointableValueState {
        EMPTY_POINTABLE,
        MISSING,
        NULL,
        PRESENT;

    }
}

