/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.comparisons;

import org.apache.asterix.dataflow.data.common.ILogicalBinaryComparator;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.comparisons.AbstractComparisonEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;

public abstract class AbstractValueComparisonEvaluator
extends AbstractComparisonEvaluator {
    private ISerializerDeserializer<ABoolean> serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);

    public AbstractValueComparisonEvaluator(IScalarEvaluatorFactory evalLeftFactory, IAType leftType, IScalarEvaluatorFactory evalRightFactory, IAType rightType, IEvaluatorContext ctx, SourceLocation sourceLoc, boolean isEquality) throws HyracksDataException {
        super(evalLeftFactory, leftType, evalRightFactory, rightType, ctx, sourceLoc, isEquality);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        ILogicalBinaryComparator.Result comparisonResult = this.compare();
        switch (comparisonResult) {
            case MISSING: {
                this.writeMissing(result);
                break;
            }
            case NULL: {
                this.writeNull(result);
                break;
            }
            case INCOMPARABLE: {
                ExceptionUtil.warnIncomparableTypes((IEvaluatorContext)this.ctx, (SourceLocation)this.sourceLoc, (ATypeTag)ATypeTag.VALUE_TYPE_MAPPING[this.argLeft.getTag()], (ATypeTag)ATypeTag.VALUE_TYPE_MAPPING[this.argRight.getTag()]);
                this.writeNull(result);
                break;
            }
            default: {
                this.resultStorage.reset();
                ABoolean b = ABoolean.valueOf((boolean)this.getComparisonResult(comparisonResult));
                this.serde.serialize((Object)b, this.out);
                result.set((IValueReference)this.resultStorage);
            }
        }
    }

    protected abstract boolean getComparisonResult(ILogicalBinaryComparator.Result var1);
}

