/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.accessors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADate;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AMutableDate;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableTime;
import org.apache.asterix.om.base.ATime;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class TemporalIntervalStartAccessor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private static final FunctionIdentifier FID = BuiltinFunctions.ACCESSOR_TEMPORAL_INTERVAL_START;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new TemporalIntervalStartAccessor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable argPtr = new VoidPointable();
                    private final IScalarEvaluator eval;
                    private final ISerializerDeserializer<ADate> dateSerde;
                    private final AMutableDate aDate;
                    private final ISerializerDeserializer<ADateTime> datetimeSerde;
                    private final AMutableDateTime aDateTime;
                    private final ISerializerDeserializer<ATime> timeSerde;
                    private final AMutableTime aTime;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.dateSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
                        this.aDate = new AMutableDate(0);
                        this.datetimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
                        this.aDateTime = new AMutableDateTime(0L);
                        this.timeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ATIME);
                        this.aTime = new AMutableTime(0);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        block7: {
                            this.eval.evaluate(tuple, this.argPtr);
                            if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr)) {
                                return;
                            }
                            byte[] bytes = this.argPtr.getByteArray();
                            int startOffset = this.argPtr.getStartOffset();
                            this.resultStorage.reset();
                            try {
                                if (bytes[startOffset] == ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG) {
                                    byte timeType = AIntervalSerializerDeserializer.getIntervalTimeType((byte[])bytes, (int)(startOffset + 1));
                                    long startTime = AIntervalSerializerDeserializer.getIntervalStart((byte[])bytes, (int)(startOffset + 1));
                                    if (timeType == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                                        this.aDate.setValue((int)startTime);
                                        this.dateSerde.serialize((Object)this.aDate, this.out);
                                        break block7;
                                    }
                                    if (timeType == ATypeTag.SERIALIZED_TIME_TYPE_TAG) {
                                        this.aTime.setValue((int)startTime);
                                        this.timeSerde.serialize((Object)this.aTime, this.out);
                                        break block7;
                                    }
                                    if (timeType == ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
                                        this.aDateTime.setValue(startTime);
                                        this.datetimeSerde.serialize((Object)this.aDateTime, this.out);
                                        break block7;
                                    }
                                    throw new InvalidDataFormatException(TemporalIntervalStartAccessor.this.sourceLoc, TemporalIntervalStartAccessor.this.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                                }
                                throw new TypeMismatchException(TemporalIntervalStartAccessor.this.sourceLoc, TemporalIntervalStartAccessor.this.getIdentifier(), (Integer)0, bytes[startOffset], ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                            }
                            catch (IOException e) {
                                throw HyracksDataException.create((Throwable)e);
                            }
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return FID;
    }
}

