/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.aggregates.std.AbstractAggregateFunction;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractSumAggregateFunction
extends AbstractAggregateFunction {
    private final IEvaluatorContext context;
    private boolean isWarned = false;
    protected ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private IPointable inputVal = new VoidPointable();
    private IScalarEvaluator eval;
    protected ATypeTag aggType;
    private long sumInt64;
    private double sumDouble;
    private AMutableInt64 aInt64 = new AMutableInt64(0L);
    private AMutableDouble aDouble = new AMutableDouble(0.0);
    private boolean isUseInt64ForResult = true;
    private ISerializerDeserializer aInt64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private ISerializerDeserializer aDoubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);

    public AbstractSumAggregateFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext context, SourceLocation sourceLoc) throws HyracksDataException {
        super(sourceLoc);
        this.context = context;
        this.eval = args[0].createScalarEvaluator(context);
    }

    protected abstract boolean skipStep();

    protected abstract void processNull();

    protected abstract void processSystemNull() throws HyracksDataException;

    protected abstract void finishNull(IPointable var1) throws IOException;

    protected abstract void finishSystemNull(IPointable var1) throws IOException;

    public void init() throws HyracksDataException {
        this.aggType = ATypeTag.SYSTEM_NULL;
        this.sumInt64 = 0L;
        this.sumDouble = 0.0;
        this.isWarned = false;
    }

    public void step(IFrameTupleReference tuple) throws HyracksDataException {
        if (this.skipStep()) {
            return;
        }
        this.eval.evaluate(tuple, this.inputVal);
        byte[] data = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(data[offset]);
        if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
            this.processNull();
            return;
        }
        if (this.aggType == ATypeTag.SYSTEM_NULL) {
            this.aggType = typeTag;
        }
        switch (typeTag) {
            case TINYINT: {
                byte val = AInt8SerializerDeserializer.getByte((byte[])data, (int)(offset + 1));
                this.processInt64Value(val);
                break;
            }
            case SMALLINT: {
                short val = AInt16SerializerDeserializer.getShort((byte[])data, (int)(offset + 1));
                this.processInt64Value(val);
                break;
            }
            case INTEGER: {
                int val = AInt32SerializerDeserializer.getInt((byte[])data, (int)(offset + 1));
                this.processInt64Value(val);
                break;
            }
            case BIGINT: {
                long val = AInt64SerializerDeserializer.getLong((byte[])data, (int)(offset + 1));
                this.processInt64Value(val);
                break;
            }
            case FLOAT: {
                this.upgradeOutputType();
                float val = AFloatSerializerDeserializer.getFloat((byte[])data, (int)(offset + 1));
                this.processFloatValue(val);
                break;
            }
            case DOUBLE: {
                this.upgradeOutputType();
                double val = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1));
                this.processFloatValue(val);
                break;
            }
            case SYSTEM_NULL: {
                this.processSystemNull();
                break;
            }
            default: {
                if (!this.isWarned) {
                    this.isWarned = true;
                    ExceptionUtil.warnUnsupportedType((IEvaluatorContext)this.context, (SourceLocation)this.sourceLoc, (String)this.getIdentifier().getName(), (ATypeTag)typeTag);
                }
                this.processNull();
            }
        }
    }

    private void upgradeOutputType() {
        this.isUseInt64ForResult = false;
    }

    private void processInt64Value(long value) throws HyracksDataException {
        if (!this.isUseInt64ForResult) {
            this.processFloatValue(value);
        } else {
            try {
                this.sumInt64 = Math.addExact(this.sumInt64, value);
                this.sumDouble = this.sumInt64;
            }
            catch (ArithmeticException ignored) {
                throw new OverflowException(this.sourceLoc, this.getIdentifier());
            }
        }
    }

    private void processFloatValue(double value) {
        this.sumDouble += value;
    }

    public void finishPartial(IPointable result) throws HyracksDataException {
        this.finishFinal(result);
    }

    public void finish(IPointable result) throws HyracksDataException {
        this.finishFinal(result);
    }

    private void finishFinal(IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        try {
            if (this.aggType == ATypeTag.SYSTEM_NULL) {
                this.finishSystemNull(result);
            } else if (this.aggType == ATypeTag.NULL) {
                this.finishNull(result);
            } else {
                if (this.isUseInt64ForResult) {
                    this.aInt64.setValue(this.sumInt64);
                    this.aInt64Serde.serialize((Object)this.aInt64, this.resultStorage.getDataOutput());
                } else {
                    this.aDouble.setValue(this.sumDouble);
                    this.aDoubleSerde.serialize((Object)this.aDouble, this.resultStorage.getDataOutput());
                }
                result.set((IValueReference)this.resultStorage);
            }
        }
        catch (IOException ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
    }

    private FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SUM;
    }
}

