/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class NumericUnaryTypeComputer
extends AbstractResultTypeComputer {
    public static final NumericUnaryTypeComputer INSTANCE = new NumericUnaryTypeComputer(null);
    public static final NumericUnaryTypeComputer INSTANCE_INT8 = new NumericUnaryTypeComputer(BuiltinType.AINT8);
    public static final NumericUnaryTypeComputer INSTANCE_DOUBLE = new NumericUnaryTypeComputer(BuiltinType.ADOUBLE);
    private final IAType returnType;

    private NumericUnaryTypeComputer(IAType returnType) {
        this.returnType = returnType;
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        ATypeTag tag = strippedInputTypes[0].getTypeTag();
        switch (tag) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                return this.returnType == null ? strippedInputTypes[0] : this.returnType;
            }
            case ANY: {
                return this.returnType == null ? BuiltinType.ANY : AUnionType.createUnknownableType(this.returnType);
            }
        }
        return BuiltinType.ANULL;
    }
}

