/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import com.esri.core.geometry.OGCStructure;
import com.esri.core.geometry.OperatorImportFromWkb;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.om.base.AGeometry;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AGeometrySerializerDeserializer
implements ISerializerDeserializer<AGeometry> {
    private static final long serialVersionUID = 1L;
    public static final AGeometrySerializerDeserializer INSTANCE = new AGeometrySerializerDeserializer();
    public static final SpatialReference DEFAULT_CRS = SpatialReference.create((int)4326);

    private AGeometrySerializerDeserializer() {
    }

    public AGeometry deserialize(DataInput in) throws HyracksDataException {
        try {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            OGCGeometry geometry = OGCGeometry.createFromOGCStructure((OGCStructure)OperatorImportFromWkb.local().executeOGC(0, buffer, null), (SpatialReference)DEFAULT_CRS);
            return new AGeometry(geometry);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void serialize(AGeometry instance, DataOutput out) throws HyracksDataException {
        try {
            OGCGeometry geometry = instance.getGeometry();
            byte[] buffer = geometry.asBinary().array();
            out.writeInt(buffer.length);
            out.write(buffer);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static int getAGeometrySizeOffset() throws HyracksDataException {
        return 0;
    }

    public static AGeometry getAGeometryObject(byte[] bytes, int startOffset) throws HyracksDataException {
        int size = AInt32SerializerDeserializer.getInt(bytes, startOffset);
        if (bytes.length < startOffset + size + 4) {
            throw HyracksDataException.create((int)43, (Serializable[])new Serializable[0]);
        }
        byte[] bytes1 = Arrays.copyOfRange(bytes, startOffset + 4, startOffset + size + 4);
        ByteBuffer buffer = ByteBuffer.wrap(bytes1);
        OGCGeometry geometry = OGCGeometry.createFromOGCStructure((OGCStructure)OperatorImportFromWkb.local().executeOGC(0, buffer, null), (SpatialReference)DEFAULT_CRS);
        return new AGeometry(geometry);
    }
}

