/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.io.Serializable;
import java.util.Objects;
import org.apache.asterix.active.EntityId;

public class ActiveRuntimeId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EntityId entityId;
    private final String runtimeName;
    private final int partition;

    public ActiveRuntimeId(EntityId entityId, String runtimeName, int partition) {
        this.entityId = entityId;
        this.runtimeName = runtimeName;
        this.partition = partition;
    }

    public String toString() {
        return "(" + this.entityId + ")[" + this.partition + "]:" + this.runtimeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveRuntimeId)) {
            return false;
        }
        ActiveRuntimeId other = (ActiveRuntimeId)o;
        return other.entityId.equals(this.entityId) && other.getRuntimeName().equals(this.runtimeName) && other.getPartition() == this.partition;
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.runtimeName, this.partition);
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public int getPartition() {
        return this.partition;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }
}

