/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs.lib;

import java.io.DataOutput;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.hdfs.api.ITupleWriter;
import org.apache.hyracks.hdfs.api.ITupleWriterFactory;

public class TextTupleWriterFactory
implements ITupleWriterFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public ITupleWriter getTupleWriter(IHyracksTaskContext ctx, int partition, int nPartition) {
        return new ITupleWriter(){
            private byte newLine = "\n".getBytes()[0];

            @Override
            public void open(DataOutput output) {
            }

            @Override
            public void write(DataOutput output, ITupleReference tuple) throws HyracksDataException {
                byte[] data = tuple.getFieldData(0);
                int start = tuple.getFieldStart(0);
                int len = tuple.getFieldLength(0);
                try {
                    output.write(data, start, len);
                    output.writeByte(this.newLine);
                }
                catch (Exception e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            @Override
            public void close(DataOutput output) {
            }
        };
    }
}

