/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.bytes;

import java.io.IOException;

public class Base64Printer {
    private static final char[] encodeMap = Base64Printer.initEncodeMap();

    public static Appendable printBase64Binary(byte[] input, int offset, int len, Appendable appendable) throws IOException {
        int remaining = len;
        int i = offset;
        while (remaining >= 3) {
            appendable.append(Base64Printer.encode(input[i] >> 2));
            appendable.append(Base64Printer.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF));
            appendable.append(Base64Printer.encode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3));
            appendable.append(Base64Printer.encode(input[i + 2] & 0x3F));
            remaining -= 3;
            i += 3;
        }
        if (remaining == 1) {
            appendable.append(Base64Printer.encode(input[i] >> 2));
            appendable.append(Base64Printer.encode((input[i] & 3) << 4));
            appendable.append('=');
            appendable.append('=');
        }
        if (remaining == 2) {
            appendable.append(Base64Printer.encode(input[i] >> 2));
            appendable.append(Base64Printer.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF));
            appendable.append(Base64Printer.encode((input[i + 1] & 0xF) << 2));
            appendable.append('=');
        }
        return appendable;
    }

    public static int printBase64Binary(byte[] input, int offset, int len, char[] buf, int ptr) {
        int remaining = len;
        int i = offset;
        while (remaining >= 3) {
            buf[ptr++] = Base64Printer.encode(input[i] >> 2);
            buf[ptr++] = Base64Printer.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
            buf[ptr++] = Base64Printer.encode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3);
            buf[ptr++] = Base64Printer.encode(input[i + 2] & 0x3F);
            remaining -= 3;
            i += 3;
        }
        if (remaining == 1) {
            buf[ptr++] = Base64Printer.encode(input[i] >> 2);
            buf[ptr++] = Base64Printer.encode((input[i] & 3) << 4);
            buf[ptr++] = 61;
            buf[ptr++] = 61;
        }
        if (remaining == 2) {
            buf[ptr++] = Base64Printer.encode(input[i] >> 2);
            buf[ptr++] = Base64Printer.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
            buf[ptr++] = Base64Printer.encode((input[i + 1] & 0xF) << 2);
            buf[ptr++] = 61;
        }
        return ptr;
    }

    private static char[] initEncodeMap() {
        int i;
        char[] map = new char[64];
        for (i = 0; i < 26; ++i) {
            map[i] = (char)(65 + i);
        }
        for (i = 26; i < 52; ++i) {
            map[i] = (char)(97 + (i - 26));
        }
        for (i = 52; i < 62; ++i) {
            map[i] = (char)(48 + (i - 52));
        }
        map[62] = 43;
        map[63] = 47;
        return map;
    }

    public static char encode(int i) {
        return encodeMap[i & 0x3F];
    }
}

