/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.freepage;

import java.io.Serializable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrameFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.buffercache.NoOpPageWriteCallback;
import org.apache.hyracks.storage.common.compression.file.ICompressedPageWriter;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class AppendOnlyLinkedMetadataPageManager
implements IMetadataPageManager {
    private final IBufferCache bufferCache;
    private int metadataPage = -1;
    private int fileId = -1;
    private final ITreeIndexMetadataFrameFactory frameFactory;
    private ICachedPage confiscatedPage;
    private boolean ready = false;

    public AppendOnlyLinkedMetadataPageManager(IBufferCache bufferCache, ITreeIndexMetadataFrameFactory frameFactory) {
        this.bufferCache = bufferCache;
        this.frameFactory = frameFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePage(ITreeIndexMetadataFrame metaFrame, int freePageNum) throws HyracksDataException {
        block8: {
            ICachedPage metaPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.getMetadataPageId()), false);
            metaPage.acquireWriteLatch();
            try {
                metaFrame.setPage(metaPage);
                if (metaFrame.getSpace() > 4) {
                    metaFrame.addFreePage(freePageNum);
                    break block8;
                }
                int newPageNum = metaFrame.getFreePage();
                if (newPageNum < 0) {
                    throw new HyracksDataException("Inconsistent Meta Page State. It has no space, but it also has no entries.");
                }
                ICachedPage newNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)newPageNum), false);
                newNode.acquireWriteLatch();
                try {
                    int metaMaxPage = metaFrame.getMaxPage();
                    System.arraycopy(metaPage.getBuffer().array(), 0, newNode.getBuffer().array(), 0, metaPage.getBuffer().capacity());
                    metaFrame.init();
                    metaFrame.setNextMetadataPage(newPageNum);
                    metaFrame.setMaxPage(metaMaxPage);
                    metaFrame.addFreePage(freePageNum);
                }
                finally {
                    newNode.releaseWriteLatch(true);
                    this.bufferCache.unpin(newNode);
                }
            }
            finally {
                metaPage.releaseWriteLatch(true);
                this.bufferCache.unpin(metaPage);
            }
        }
    }

    @Override
    public void releaseBlock(ITreeIndexMetadataFrame metaFrame, int startingPage, int count) throws HyracksDataException {
        for (int i = 0; i < count; ++i) {
            this.releasePage(metaFrame, startingPage + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int takePage(ITreeIndexMetadataFrame metaFrame) throws HyracksDataException {
        int freePage;
        block9: {
            this.confiscatedPage.acquireWriteLatch();
            freePage = -1;
            try {
                metaFrame.setPage(this.confiscatedPage);
                freePage = metaFrame.getFreePage();
                if (freePage >= 0) break block9;
                int nextPage = metaFrame.getNextMetadataPage();
                if (nextPage > 0) {
                    ICachedPage nextNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)nextPage), false);
                    nextNode.acquireWriteLatch();
                    try {
                        int maxPage = metaFrame.getMaxPage();
                        System.arraycopy(nextNode.getBuffer().array(), 0, this.confiscatedPage.getBuffer().array(), 0, nextNode.getBuffer().capacity());
                        metaFrame.setMaxPage(maxPage);
                        freePage = metaFrame.getFreePage();
                        if (freePage < 0) {
                            freePage = nextPage;
                        } else {
                            metaFrame.addFreePage(nextPage);
                        }
                        break block9;
                    }
                    finally {
                        nextNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(nextNode);
                    }
                }
                freePage = metaFrame.getMaxPage();
                metaFrame.setMaxPage(++freePage);
            }
            finally {
                this.confiscatedPage.releaseWriteLatch(false);
            }
        }
        return freePage;
    }

    @Override
    public int takeBlock(ITreeIndexMetadataFrame metaFrame, int count) throws HyracksDataException {
        int maxPage = metaFrame.getMaxPage();
        metaFrame.setMaxPage(maxPage + count);
        return maxPage + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxPageId(ITreeIndexMetadataFrame metaFrame) throws HyracksDataException {
        ICachedPage metaNode;
        if (this.confiscatedPage == null) {
            int mdPage = this.getMetadataPageId();
            if (mdPage < 0) {
                return -1;
            }
            metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)mdPage), false);
        } else {
            metaNode = this.confiscatedPage;
        }
        metaNode.acquireReadLatch();
        int maxPage = -1;
        try {
            metaFrame.setPage(metaNode);
            maxPage = metaFrame.getMaxPage();
        }
        finally {
            metaNode.releaseReadLatch();
            if (this.confiscatedPage == null) {
                this.bufferCache.unpin(metaNode);
            }
        }
        return maxPage;
    }

    @Override
    public void init(ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory) throws HyracksDataException {
    }

    @Override
    public ITreeIndexMetadataFrame createMetadataFrame() {
        return this.frameFactory.createFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(int fileId) throws HyracksDataException {
        this.fileId = fileId;
        int pages = this.bufferCache.getNumPagesOfFile(fileId);
        if (pages == 0) {
            if (this.confiscatedPage != null) {
                throw new HyracksDataException("Metadata Page Manager is already initialized");
            }
            ITreeIndexMetadataFrame metaFrame = this.createMetadataFrame();
            ICachedPage metaNode = this.bufferCache.confiscatePage(-1L);
            try {
                metaFrame.setPage(metaNode);
                metaFrame.init();
                metaFrame.setMaxPage(-1);
            }
            finally {
                this.confiscatedPage = metaNode;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(IPageWriteFailureCallback failureCallback) throws HyracksDataException {
        if (this.ready) {
            IFIFOPageWriter pageWriter = this.bufferCache.createFIFOWriter((IPageWriteCallback)NoOpPageWriteCallback.INSTANCE, failureCallback);
            ITreeIndexMetadataFrame metaFrame = this.frameFactory.createFrame();
            this.confiscatedPage.acquireWriteLatch();
            try {
                metaFrame.setPage(this.confiscatedPage);
                metaFrame.setValid(true);
            }
            finally {
                this.confiscatedPage.releaseWriteLatch(false);
            }
            int finalMetaPage = this.getMaxPageId(metaFrame) + 1;
            this.confiscatedPage.setDiskPageId(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)finalMetaPage));
            ICompressedPageWriter compressedPageWriter = this.bufferCache.getCompressedPageWriter(this.fileId);
            compressedPageWriter.prepareWrite(this.confiscatedPage);
            pageWriter.write(this.confiscatedPage);
            compressedPageWriter.endWriting();
            this.metadataPage = this.getMetadataPageId();
            this.ready = false;
        } else if (this.confiscatedPage != null) {
            this.bufferCache.returnPage(this.confiscatedPage, false);
        }
        this.confiscatedPage = null;
    }

    @Override
    public int getMetadataPageId() throws HyracksDataException {
        if (this.metadataPage != -1) {
            return this.metadataPage;
        }
        int pages = this.bufferCache.getNumPagesOfFile(this.fileId);
        if (pages == 0) {
            return -1;
        }
        this.metadataPage = pages - 1;
        return this.metadataPage;
    }

    @Override
    public boolean isEmpty(ITreeIndexFrame frame, int rootPage) throws HyracksDataException {
        return this.bufferCache.getNumPagesOfFile(this.fileId) <= 2;
    }

    @Override
    public void setRootPageId(int rootPage) throws HyracksDataException {
        ITreeIndexMetadataFrame metaFrame = this.frameFactory.createFrame();
        this.confiscatedPage.acquireWriteLatch();
        try {
            metaFrame.setPage(this.confiscatedPage);
            metaFrame.setRootPageId(rootPage);
        }
        finally {
            this.confiscatedPage.releaseWriteLatch(false);
        }
        this.ready = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRootPageId() throws HyracksDataException {
        ICachedPage metaNode = this.confiscatedPage == null ? this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.getMetadataPageId()), false) : this.confiscatedPage;
        ITreeIndexMetadataFrame metaFrame = this.frameFactory.createFrame();
        metaNode.acquireReadLatch();
        try {
            metaFrame.setPage(metaNode);
            int n = metaFrame.getRootPageId();
            return n;
        }
        finally {
            metaNode.releaseReadLatch();
            if (this.confiscatedPage == null) {
                this.bufferCache.unpin(metaNode);
            }
        }
    }

    @Override
    public int getBulkLoadLeaf() throws HyracksDataException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ITreeIndexMetadataFrame frame, IValueReference key, IValueReference value) throws HyracksDataException {
        if (this.confiscatedPage == null) {
            throw HyracksDataException.create((int)12, (Serializable[])new Serializable[0]);
        }
        this.confiscatedPage.acquireWriteLatch();
        try {
            frame.setPage(this.confiscatedPage);
            frame.put(key, value);
        }
        finally {
            this.confiscatedPage.releaseWriteLatch(false);
        }
    }

    private ICachedPage pinPage() throws HyracksDataException {
        return this.confiscatedPage == null ? this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.getMetadataPageId()), false) : this.confiscatedPage;
    }

    private void unpinPage(ICachedPage page) throws HyracksDataException {
        if (this.confiscatedPage == null) {
            this.bufferCache.unpin(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(ITreeIndexMetadataFrame frame, IValueReference key, IPointable value) throws HyracksDataException {
        ICachedPage page = this.pinPage();
        page.acquireReadLatch();
        try {
            frame.setPage(page);
            frame.get(key, value);
        }
        finally {
            page.releaseReadLatch();
            this.unpinPage(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileOffset(ITreeIndexMetadataFrame frame, IValueReference key) throws HyracksDataException {
        int pageId = this.getMetadataPageId();
        if (pageId != -1) {
            ICachedPage page = this.pinPage();
            page.acquireReadLatch();
            try {
                frame.setPage(page);
                int inPageOffset = frame.getOffset(key);
                long l = inPageOffset >= 0 ? (long)pageId * (long)this.bufferCache.getPageSizeWithHeader() + (long)frame.getOffset(key) + 8L : -1L;
                return l;
            }
            finally {
                page.releaseReadLatch();
                this.unpinPage(page);
            }
        }
        return -1L;
    }
}

