/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.frames;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public class LIFOMetaDataFrame
implements ITreeIndexMetadataFrame {
    private static final byte META_PAGE_LEVEL_INDICATOR = -1;
    private static final byte FREE_PAGE_LEVEL_INDICATOR = -2;
    protected static final int MAGIC_VALID_INT = 454482554;
    protected static final int MAX_PAGE_OFFSET = 9;
    protected static final int NEXT_PAGE_OFFSET = 13;
    protected static final int VALID_OFFSET = 17;
    protected static final int STORAGE_VERSION_OFFSET = 21;
    protected static final int ROOT_PAGE_OFFSET = 25;
    protected static final int FREE_PAGE_COUNT_OFFSET = 29;
    protected static final int HEADER_END_OFFSET = 33;
    protected ICachedPage page = null;
    protected ByteBuffer buf = null;

    @Override
    public int getMaxPage() {
        return this.buf.getInt(9);
    }

    @Override
    public void setMaxPage(int maxPage) {
        this.buf.putInt(9, maxPage);
    }

    @Override
    public int getFreePage() {
        int freePages = this.buf.getInt(29);
        if (freePages > 0) {
            this.decrement(29);
            return this.buf.getInt(this.buf.array().length - 4 * freePages);
        }
        return -1;
    }

    @Override
    public int getSpace() {
        return this.buf.array().length - this.buf.getInt(4) - 4 * this.buf.getInt(29);
    }

    @Override
    public void addFreePage(int freePage) {
        this.increment(29);
        int numFreePages = this.buf.getInt(29);
        this.buf.putInt(this.buf.array().length - 4 * numFreePages, freePage);
    }

    @Override
    public byte getLevel() {
        return this.buf.get(8);
    }

    @Override
    public void setLevel(byte level) {
        this.buf.put(8, level);
    }

    @Override
    public ICachedPage getPage() {
        return this.page;
    }

    @Override
    public void setPage(ICachedPage page) {
        this.page = page;
        this.buf = page.getBuffer();
    }

    @Override
    public void init() {
        this.buf.putInt(0, 0);
        this.buf.putInt(4, 33);
        this.buf.putInt(9, 0);
        this.buf.put(8, (byte)-1);
        this.buf.putInt(13, -1);
        this.buf.putInt(25, 1);
        this.buf.putInt(29, 0);
        this.buf.putInt(21, 7);
        this.setValid(false);
    }

    @Override
    public int getNextMetadataPage() {
        return this.buf.getInt(13);
    }

    @Override
    public void setNextMetadataPage(int nextPage) {
        this.buf.putInt(13, nextPage);
    }

    @Override
    public boolean isValid() {
        return this.buf.getInt(17) == 454482554;
    }

    @Override
    public void setValid(boolean isValid) {
        this.buf.putInt(17, isValid ? 454482554 : 0);
    }

    @Override
    public int getVersion() {
        return this.buf.getInt(21);
    }

    @Override
    public void setRootPageId(int rootPage) {
        this.buf.putInt(25, rootPage);
    }

    @Override
    public int getRootPageId() {
        return this.buf.getInt(25);
    }

    @Override
    public boolean isMetadataPage() {
        return this.getLevel() == -1;
    }

    @Override
    public boolean isFreePage() {
        return this.getLevel() == -2;
    }

    @Override
    public void get(IValueReference key, IPointable value) {
        int tupleCount = this.getTupleCount();
        int tupleStart = this.getTupleStart(0);
        for (int i = 0; i < tupleCount; ++i) {
            if (this.isInner(key, tupleStart)) {
                this.get(tupleStart + key.getLength() + 4, value);
                return;
            }
            tupleStart = this.getNextTupleStart(tupleStart);
        }
        value.set(null, 0, 0);
    }

    private int find(IValueReference key) {
        int tupleCount = this.getTupleCount();
        int tupleStart = this.getTupleStart(0);
        for (int i = 0; i < tupleCount; ++i) {
            if (this.isInner(key, tupleStart)) {
                return i;
            }
            tupleStart = this.getNextTupleStart(tupleStart);
        }
        return -1;
    }

    private void get(int offset, IPointable value) {
        int valueLength = this.buf.getInt(offset);
        value.set(this.buf.array(), offset + 4, valueLength);
    }

    private static final int compare(byte[] b1, int s1, byte[] b2, int s2, int l) {
        for (int i = 0; i < l; ++i) {
            if (b1[s1 + i] == b2[s2 + i]) continue;
            return b1[s1 + i] - b2[s2 + i];
        }
        return 0;
    }

    private boolean isInner(IValueReference key, int tupleOffset) {
        int keySize = this.buf.getInt(tupleOffset);
        if (keySize == key.getLength()) {
            return LIFOMetaDataFrame.compare(key.getByteArray(), key.getStartOffset(), this.buf.array(), tupleOffset + 4, keySize) == 0;
        }
        return false;
    }

    private int getTupleStart(int index) {
        int offset = 33;
        for (int i = 0; i < index; ++i) {
            offset = this.getNextTupleStart(offset);
        }
        return offset;
    }

    private int getNextTupleStart(int prevTupleOffset) {
        int keyLength = this.buf.getInt(prevTupleOffset);
        int offset = prevTupleOffset + keyLength + 4;
        return offset + this.buf.getInt(offset) + 4;
    }

    private void put(int index, IValueReference value) throws HyracksDataException {
        int offset = this.getTupleStart(index);
        int length = this.buf.getInt(offset);
        if ((length = this.buf.getInt(offset += 4 + length)) != value.getLength()) {
            throw new HyracksDataException("This frame doesn't support overwriting dynamically sized values");
        }
        System.arraycopy(value.getByteArray(), value.getStartOffset(), this.buf.array(), offset += 4, value.getLength());
    }

    @Override
    public void put(IValueReference key, IValueReference value) throws HyracksDataException {
        int index = this.find(key);
        if (index >= 0) {
            this.put(index, value);
        } else {
            int required;
            int offset = this.buf.getInt(4);
            int available = this.getSpace();
            if (available < (required = key.getLength() + 4 + 4 + value.getLength())) {
                throw new HyracksDataException("Available space in the page (" + available + ") is not enough to store the key value pair(" + required + ")");
            }
            this.buf.putInt(offset, key.getLength());
            System.arraycopy(key.getByteArray(), key.getStartOffset(), this.buf.array(), offset += 4, key.getLength());
            this.buf.putInt(offset += key.getLength(), value.getLength());
            System.arraycopy(value.getByteArray(), value.getStartOffset(), this.buf.array(), offset += 4, value.getLength());
            this.increment(0);
            this.buf.putInt(4, offset += value.getLength());
        }
    }

    @Override
    public int getTupleCount() {
        return this.buf.getInt(0);
    }

    private void increment(int offset) {
        this.buf.putInt(offset, this.buf.getInt(offset) + 1);
    }

    private void decrement(int offset) {
        this.buf.putInt(offset, this.buf.getInt(offset) - 1);
    }

    @Override
    public int getOffset(IValueReference key) {
        int index = this.find(key);
        if (index >= 0) {
            int offset = this.getTupleStart(index);
            return offset + key.getLength() + 8;
        }
        return -1;
    }

    public String toString() {
        StringBuilder aString = new StringBuilder(this.getClass().getSimpleName()).append('\n').append("Tuple Count: " + this.getTupleCount()).append('\n').append("Free Space offset: " + this.buf.getInt(4)).append('\n').append("Level: " + this.buf.get(8)).append('\n').append("Version: " + this.buf.getInt(21)).append('\n').append("Max Page: " + this.buf.getInt(9)).append('\n').append("Root Page: " + this.buf.getInt(25)).append('\n').append("Number of free pages: " + this.buf.getInt(29));
        int tupleCount = this.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            int offset = this.getTupleStart(i);
            int keyLength = this.buf.getInt(offset);
            aString.append('\n').append("Key " + i + " size = " + keyLength);
            int valueLength = this.buf.getInt(offset += 4 + keyLength);
            aString.append(", Value " + i + " size = " + valueLength);
        }
        return aString.toString();
    }
}

