/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.recordgroup;

import org.apache.asterix.fuzzyjoin.recordgroup.RecordGroup;
import org.apache.asterix.fuzzyjoin.recordgroup.RecordGroupLengthCount;
import org.apache.asterix.fuzzyjoin.recordgroup.RecordGroupLengthIdentity;
import org.apache.asterix.fuzzyjoin.recordgroup.RecordGroupLengthRange;
import org.apache.asterix.fuzzyjoin.recordgroup.RecordGroupSingle;
import org.apache.asterix.fuzzyjoin.recordgroup.RecordGroupTokenFrequency;
import org.apache.asterix.fuzzyjoin.recordgroup.RecordGroupTokenFrequencyMirror;
import org.apache.asterix.fuzzyjoin.recordgroup.RecordGroupTokenIdentity;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFilters;

public class RecordGroupFactory {
    public static RecordGroup getRecordGroup(String recordGroup, int noGroups, SimilarityFilters fuzzyFilters, String lengthstatsPath) {
        if (recordGroup.equals("LengthCount")) {
            return new RecordGroupLengthCount(noGroups, fuzzyFilters, lengthstatsPath);
        }
        if (recordGroup.equals("LengthIdentity")) {
            return new RecordGroupLengthIdentity(noGroups, fuzzyFilters);
        }
        if (recordGroup.equals("LengthRange")) {
            return new RecordGroupLengthRange(noGroups, fuzzyFilters, lengthstatsPath);
        }
        if (recordGroup.equals("Single")) {
            return new RecordGroupSingle(noGroups, fuzzyFilters);
        }
        if (recordGroup.equals("TokenIdentity")) {
            return new RecordGroupTokenIdentity(noGroups, fuzzyFilters);
        }
        if (recordGroup.equals("TokenFrequency")) {
            return new RecordGroupTokenFrequency(noGroups, fuzzyFilters);
        }
        if (recordGroup.equals("TokenFrequencyMirror")) {
            return new RecordGroupTokenFrequencyMirror(noGroups, fuzzyFilters);
        }
        throw new RuntimeException("Unknown record group \"" + recordGroup + "\".");
    }
}

