/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin;

public class FuzzyFiltersJaccard {
    protected final double simThr;
    protected final double simThrExpr;

    public FuzzyFiltersJaccard(double similarityThreshold) {
        this.simThr = similarityThreshold;
        this.simThrExpr = this.simThr / (1.0 + this.simThr);
    }

    public int getIndexPrefixLength(int length) {
        return length - (int)Math.ceil(2.0 * this.simThrExpr * (double)length) + 1;
    }

    public int getIntersectLowerBound(int lengthX, int lengthY) {
        return (int)Math.ceil(this.simThrExpr * (double)(lengthX + lengthY));
    }

    public long getIntersectLowerBound(long lengthX, long lengthY) {
        return (long)Math.ceil(this.simThrExpr * (double)(lengthX + lengthY));
    }

    public int getIntersectUpperBound(int noGramsCommon, int positionX, int positionY, int lengthX, int lengthY) {
        return noGramsCommon + Math.min(lengthX - positionX - 1, lengthY - positionY - 1);
    }

    public long getIntersectUpperBound(int noGramsCommon, long positionX, long positionY, long lengthX, long lengthY) {
        return (long)noGramsCommon + Math.min(lengthX - positionX - 1L, lengthY - positionY - 1L);
    }

    public int getLengthLowerBound(int length) {
        return (int)Math.ceil(this.simThr * (double)length);
    }

    public long getLengthLowerBound(long length) {
        return (long)Math.ceil(this.simThr * (double)length);
    }

    public int getPrefixLength(int length) {
        return length - (int)Math.ceil(this.simThr * (double)length) + 1;
    }

    public long getPrefixLength(long length) {
        return length - (long)Math.ceil(this.simThr * (double)length) + 1L;
    }

    public double getSimilarityThreshold() {
        return this.simThr;
    }

    public boolean passLengthFilter(int lengthX, int lengthY) {
        return this.getLengthLowerBound(lengthX) <= lengthY && (double)lengthY <= 1.0 / this.simThr * (double)lengthX;
    }

    public boolean passLengthFilter(long lengthX, long lengthY) {
        return this.getLengthLowerBound(lengthX) <= lengthY && (double)lengthY <= 1.0 / this.simThr * (double)lengthX;
    }

    public boolean passPositionFilter(int noGramsCommon, int positionX, int positionY, int lengthX, int lengthY) {
        return this.getIntersectUpperBound(noGramsCommon, positionX, positionY, lengthX, lengthY) >= this.getIntersectLowerBound(lengthX, lengthY);
    }

    public boolean passPositionFilter(int noGramsCommon, long positionX, long positionY, long lengthX, long lengthY) {
        return this.getIntersectUpperBound(noGramsCommon, positionX, positionY, lengthX, lengthY) >= this.getIntersectLowerBound(lengthX, lengthY);
    }
}

