/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IWritable;

public final class JobId
implements IWritable,
Serializable,
Comparable {
    private static final Pattern jobIdPattern = Pattern.compile("^JID:(\\d+)\\.(\\d+)$");
    public static final JobId INVALID = null;
    private static final long serialVersionUID = 1L;
    private long id;
    private volatile transient CcId ccId;

    public static JobId create(DataInput dis) throws IOException {
        JobId jobId = new JobId();
        jobId.readFields(dis);
        return jobId;
    }

    private JobId() {
    }

    public JobId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public CcId getCcId() {
        if (this.ccId == null) {
            this.ccId = CcId.valueOf((int)(this.id >>> 48));
        }
        return this.ccId;
    }

    public long getIdOnly() {
        return this.id & 0xFFFFFFFFFFFFL;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof JobId && ((JobId)o).id == this.id;
    }

    public String toString() {
        return "JID:" + (this.id >>> 48) + "." + this.getIdOnly();
    }

    public static JobId parse(String str) throws HyracksDataException {
        int ccId;
        Matcher m = jobIdPattern.matcher(str);
        if (m.matches() && (ccId = Integer.parseInt(m.group(1))) <= 65535 && ccId >= 0) {
            long jobId = Long.parseLong(m.group(2)) | (long)ccId << 48;
            return new JobId(jobId);
        }
        throw HyracksDataException.create(20, new Serializable[]{str});
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        output.writeLong(this.id);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.id = input.readLong();
    }

    public int compareTo(Object other) {
        return Long.compare(this.id, ((JobId)other).id);
    }
}

