/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.comm;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class VSizeFrame
implements IFrame {
    protected final int minFrameSize;
    protected IHyracksFrameMgrContext ctx;
    protected ByteBuffer buffer;

    public VSizeFrame(IHyracksFrameMgrContext ctx) throws HyracksDataException {
        this(ctx, ctx.getInitialFrameSize());
    }

    public VSizeFrame(IHyracksFrameMgrContext ctx, int frameSize) throws HyracksDataException {
        this.minFrameSize = ctx.getInitialFrameSize();
        this.ctx = ctx;
        this.buffer = ctx.allocateFrame(frameSize);
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void ensureFrameSize(int newSize) throws HyracksDataException {
        if (newSize > this.getFrameSize()) {
            this.buffer = this.ctx.reallocateFrame(this.buffer, newSize, true);
        }
    }

    @Override
    public void resize(int frameSize) throws HyracksDataException {
        if (this.getFrameSize() != frameSize) {
            this.buffer = this.ctx.reallocateFrame(this.buffer, frameSize, false);
        }
    }

    @Override
    public int getFrameSize() {
        return this.buffer.capacity();
    }

    @Override
    public int getMinSize() {
        return this.minFrameSize;
    }

    @Override
    public void reset() throws HyracksDataException {
        this.resize(this.minFrameSize);
        this.buffer.clear();
    }
}

