/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.deployment;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hyracks.control.common.deployment.DeploymentStatus;
import org.apache.hyracks.control.common.deployment.IDeploymentStatusConditionVariable;

public class DeploymentRun
implements IDeploymentStatusConditionVariable {
    private DeploymentStatus deploymentStatus = DeploymentStatus.FAIL;
    private final Set<String> deploymentNodeIds = new TreeSet<String>();

    public DeploymentRun(Collection<String> nodeIds) {
        this.deploymentNodeIds.addAll(nodeIds);
    }

    public synchronized void notifyDeploymentStatus(String nodeId, DeploymentStatus status) {
        if (status == DeploymentStatus.SUCCEED) {
            this.deploymentNodeIds.remove(nodeId);
            if (this.deploymentNodeIds.size() == 0) {
                this.deploymentStatus = DeploymentStatus.SUCCEED;
                this.notifyAll();
            }
        } else {
            this.deploymentNodeIds.clear();
            this.deploymentStatus = DeploymentStatus.FAIL;
            this.notifyAll();
        }
    }

    @Override
    public synchronized DeploymentStatus waitForCompletion() throws Exception {
        this.wait();
        return this.deploymentStatus;
    }
}

