/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.WarningUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class RemoveDuplicateFieldsRule
implements IAlgebraicRewriteRule {
    private final Set<String> fieldNames = new HashSet<String>();
    private IOptimizationContext context;

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext ctx) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext ctx) throws AlgebricksException {
        if (ctx.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        this.context = ctx;
        return this.rewriteOpAndInputs(opRef, true);
    }

    private boolean rewriteOpAndInputs(Mutable<ILogicalOperator> opRef, boolean first) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (!first) {
            this.context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        }
        List inputs = op.getInputs();
        boolean changed = false;
        int size = inputs.size();
        for (int i = 0; i < size; ++i) {
            changed |= this.rewriteOpAndInputs((Mutable<ILogicalOperator>)((Mutable)inputs.get(i)), false);
        }
        return changed |= op.acceptExpressionTransform(this::transform);
    }

    private boolean transform(Mutable<ILogicalExpression> expressionRef) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)expressionRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression function = (AbstractFunctionCallExpression)expr;
        boolean changed = false;
        if (function.getFunctionIdentifier().equals((Object)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR) || function.getFunctionIdentifier().equals((Object)BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR)) {
            if (function.getArguments().size() % 2 != 0) {
                String functionName = function.getFunctionIdentifier().getName();
                throw CompilationException.create((int)1087, (SourceLocation)expr.getSourceLocation(), (Serializable[])new Serializable[]{functionName});
            }
            this.fieldNames.clear();
            Iterator iterator = function.getArguments().iterator();
            while (iterator.hasNext()) {
                ILogicalExpression fieldNameExpr = (ILogicalExpression)((Mutable)iterator.next()).getValue();
                String fieldName = ConstantExpressionUtil.getStringConstant((ILogicalExpression)fieldNameExpr);
                if (fieldName != null && !this.fieldNames.add(fieldName)) {
                    IWarningCollector warningCollector = this.context.getWarningCollector();
                    if (warningCollector.shouldWarn()) {
                        warningCollector.warn(WarningUtil.forAsterix((SourceLocation)fieldNameExpr.getSourceLocation(), (int)1006, (Serializable[])new Serializable[]{fieldName}));
                    }
                    iterator.remove();
                    iterator.next();
                    iterator.remove();
                    changed = true;
                    continue;
                }
                iterator.next();
            }
        }
        List arguments = function.getArguments();
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            changed |= this.transform((Mutable<ILogicalExpression>)((Mutable)arguments.get(i)));
        }
        return changed;
    }
}

