/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public class StreamRecordReaderProvider {
    private static final String RESOURCE = "META-INF/services/org.apache.asterix.external.input.record.reader.stream.StreamRecordReader";
    private static Map<String, List<Pair<String[], Class>>> recordReaders = null;

    protected static StreamRecordReader getInstance(Class clazz) throws AsterixException {
        try {
            return (StreamRecordReader)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Cannot create RecordReader: " + clazz.getSimpleName(), (Throwable)e);
        }
    }

    private StreamRecordReaderProvider() {
    }

    public static Class findRecordReaderClazzWithConfig(Map<String, String> configuration, String format) throws AsterixException {
        List<Pair<String[], Class>> requiredConfigs = recordReaders.get(format);
        Class clazz = null;
        int maxOptNum = 0;
        for (Pair<String[], Class> configPair : requiredConfigs) {
            Boolean matchFlag = true;
            int matchOptNum = 0;
            for (String configKey : (String[])configPair.getLeft()) {
                if (configKey.length() > 0 && !configuration.containsKey(configKey)) {
                    matchFlag = false;
                    break;
                }
                if (configKey.length() <= 0) continue;
                ++matchOptNum;
            }
            if (!matchFlag.booleanValue() || matchOptNum < maxOptNum) continue;
            clazz = (Class)configPair.getRight();
            maxOptNum = matchOptNum;
        }
        if (clazz != null) {
            return clazz;
        }
        throw new AsterixException(3086, new Serializable[]{format});
    }

    public static Class getRecordReaderClazz(Map<String, String> configuration) throws AsterixException {
        String format = configuration.get("format");
        if (recordReaders == null) {
            recordReaders = StreamRecordReaderProvider.initRecordReaders();
        }
        if (format != null) {
            if (recordReaders.containsKey(format)) {
                return StreamRecordReaderProvider.findRecordReaderClazzWithConfig(configuration, format);
            }
            throw new AsterixException(3026, new Serializable[]{format});
        }
        throw new AsterixException("Unspecified parameter: format");
    }

    protected static Map<String, List<Pair<String[], Class>>> initRecordReaders() throws AsterixException {
        HashMap<String, List<Pair<String[], Class>>> recordReaders = new HashMap<String, List<Pair<String[], Class>>>();
        ClassLoader cl = StreamRecordReaderProvider.class.getClassLoader();
        Charset encoding = Charset.forName("UTF-8");
        try {
            Enumeration<URL> urls = cl.getResources(RESOURCE);
            for (URL url : Collections.list(urls)) {
                String[] classNames;
                InputStream is = url.openStream();
                String config = IOUtils.toString((InputStream)is, (Charset)encoding);
                is.close();
                for (String className : classNames = config.split("\n")) {
                    if (className.startsWith("#")) continue;
                    Class<?> clazz = Class.forName(className);
                    StreamRecordReader newInstance = (StreamRecordReader)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    List<String> formats = newInstance.getRecordReaderFormats();
                    String[] configs = newInstance.getRequiredConfigs().split(":");
                    for (String format : formats) {
                        if (!recordReaders.containsKey(format)) {
                            recordReaders.put(format, new ArrayList());
                        }
                        ((List)recordReaders.get(format)).add(Pair.of((Object)configs, clazz));
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AsterixException((Throwable)e);
        }
        return recordReaders;
    }
}

