/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.external.api.IDataParser;
import org.apache.asterix.external.parser.ParseException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABinary;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ACircle;
import org.apache.asterix.om.base.ADate;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.ADayTimeDuration;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.ADuration;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AGeometry;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.ALine;
import org.apache.asterix.om.base.AMutableBinary;
import org.apache.asterix.om.base.AMutableCircle;
import org.apache.asterix.om.base.AMutableDate;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableDayTimeDuration;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableDuration;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableGeometry;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.base.AMutableLine;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.AMutablePoint3D;
import org.apache.asterix.om.base.AMutableRectangle;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AMutableTime;
import org.apache.asterix.om.base.AMutableUUID;
import org.apache.asterix.om.base.AMutableYearMonthDuration;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.APoint3D;
import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.ATime;
import org.apache.asterix.om.base.AUUID;
import org.apache.asterix.om.base.AYearMonthDuration;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.ADateParserFactory;
import org.apache.asterix.om.base.temporal.ADateTimeParserFactory;
import org.apache.asterix.om.base.temporal.ADurationParserFactory;
import org.apache.asterix.om.base.temporal.ATimeParserFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.bytes.Base64Parser;
import org.apache.hyracks.util.bytes.HexParser;
import org.apache.hyracks.util.string.UTF8StringReader;
import org.apache.hyracks.util.string.UTF8StringWriter;

public abstract class AbstractDataParser
implements IDataParser {
    protected AMutableInt8 aInt8 = new AMutableInt8(0);
    protected AMutableInt16 aInt16 = new AMutableInt16(0);
    protected AMutableInt32 aInt32 = new AMutableInt32(0);
    protected AMutableInt64 aInt64 = new AMutableInt64(0L);
    protected AMutableDouble aDouble = new AMutableDouble(0.0);
    protected AMutableFloat aFloat = new AMutableFloat(0.0f);
    protected AMutableString aString = new AMutableString("");
    protected AMutableBinary aBinary = new AMutableBinary(null, 0, 0);
    protected AMutableString aStringFieldName = new AMutableString("");
    protected AMutableUUID aUUID = new AMutableUUID();
    protected AMutableGeometry aGeomtry = new AMutableGeometry(null);
    protected AMutableTime aTime = new AMutableTime(0);
    protected AMutableDateTime aDateTime = new AMutableDateTime(0L);
    protected AMutableDuration aDuration = new AMutableDuration(0, 0L);
    protected AMutableDayTimeDuration aDayTimeDuration = new AMutableDayTimeDuration(0L);
    protected AMutableYearMonthDuration aYearMonthDuration = new AMutableYearMonthDuration(0);
    protected AMutablePoint aPoint = new AMutablePoint(0.0, 0.0);
    protected AMutablePoint3D aPoint3D = new AMutablePoint3D(0.0, 0.0, 0.0);
    protected AMutableCircle aCircle = new AMutableCircle(null, 0.0);
    protected AMutableRectangle aRectangle = new AMutableRectangle(null, null);
    protected AMutablePoint aPoint2 = new AMutablePoint(0.0, 0.0);
    protected AMutableLine aLine = new AMutableLine(null, null);
    protected AMutableDate aDate = new AMutableDate(0);
    protected AMutableInterval aInterval = new AMutableInterval(0L, 0L, 0);
    protected ISerializerDeserializer<ADouble> doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    protected ISerializerDeserializer<AString> stringSerde = SerializerDeserializerProvider.INSTANCE.getAStringSerializerDeserializer();
    protected ISerializerDeserializer<ABinary> binarySerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABINARY);
    protected ISerializerDeserializer<AFloat> floatSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
    protected ISerializerDeserializer<AInt8> int8Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
    protected ISerializerDeserializer<AInt16> int16Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT16);
    protected ISerializerDeserializer<AInt32> int32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    protected ISerializerDeserializer<AInt64> int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    protected ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    protected ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
    protected final AStringSerializerDeserializer untaggedStringSerde = new AStringSerializerDeserializer(new UTF8StringWriter(), new UTF8StringReader());
    protected final HexParser hexParser = new HexParser();
    protected final Base64Parser base64Parser = new Base64Parser();
    protected ISerializerDeserializer<AUUID> uuidSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AUUID);
    protected ISerializerDeserializer<AGeometry> geomSerde = SerializerDeserializerProvider.INSTANCE.getNonTaggedSerializerDeserializer((IAType)BuiltinType.AGEOMETRY);
    protected static final ISerializerDeserializer<ATime> timeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ATIME);
    protected static final ISerializerDeserializer<ADate> dateSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
    protected static final ISerializerDeserializer<ADateTime> datetimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
    protected static final ISerializerDeserializer<ADuration> durationSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADURATION);
    protected static final ISerializerDeserializer<ADayTimeDuration> dayTimeDurationSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADAYTIMEDURATION);
    protected static final ISerializerDeserializer<AYearMonthDuration> yearMonthDurationSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AYEARMONTHDURATION);
    protected static final ISerializerDeserializer<APoint> pointSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.APOINT);
    protected static final ISerializerDeserializer<APoint3D> point3DSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.APOINT3D);
    protected static final ISerializerDeserializer<ACircle> circleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ACIRCLE);
    protected static final ISerializerDeserializer<ARectangle> rectangleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ARECTANGLE);
    protected static final ISerializerDeserializer<ALine> lineSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ALINE);
    protected static final ISerializerDeserializer<AInterval> intervalSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINTERVAL);
    protected String filename;

    void setFilename(String filename) {
        this.filename = filename;
    }

    protected void parseTime(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        int chrononTimeInMs = ATimeParserFactory.parseTimePart((char[])buffer, (int)begin, (int)len);
        this.aTime.setValue(chrononTimeInMs);
        timeSerde.serialize((Object)this.aTime, out);
    }

    protected void parseDate(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        int chrononTimeInDays = ADateParserFactory.parseDatePartInDays((char[])buffer, (int)begin, (int)len);
        this.aDate.setValue(chrononTimeInDays);
        dateSerde.serialize((Object)this.aDate, out);
    }

    protected void parseDateTime(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        long chrononDatetimeInMs = ADateTimeParserFactory.parseDateTimePart((char[])buffer, (int)begin, (int)len);
        this.aDateTime.setValue(chrononDatetimeInMs);
        datetimeSerde.serialize((Object)this.aDateTime, out);
    }

    protected void parseDuration(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        ADurationParserFactory.parseDuration((Object)buffer, (int)begin, (int)len, (IAObject)this.aDuration, (ADurationParserFactory.ADurationParseOption)ADurationParserFactory.ADurationParseOption.All);
        durationSerde.serialize((Object)this.aDuration, out);
    }

    protected void parseDateTimeDuration(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        ADurationParserFactory.parseDuration((Object)buffer, (int)begin, (int)len, (IAObject)this.aDayTimeDuration, (ADurationParserFactory.ADurationParseOption)ADurationParserFactory.ADurationParseOption.All);
        dayTimeDurationSerde.serialize((Object)this.aDayTimeDuration, out);
    }

    protected void parseYearMonthDuration(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        ADurationParserFactory.parseDuration((Object)buffer, (int)begin, (int)len, (IAObject)this.aYearMonthDuration, (ADurationParserFactory.ADurationParseOption)ADurationParserFactory.ADurationParseOption.All);
        yearMonthDurationSerde.serialize((Object)this.aYearMonthDuration, out);
    }

    protected void parsePoint(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        try {
            int commaIndex = this.indexOf(buffer, begin, len, ',');
            this.aPoint.setValue(this.parseDouble(buffer, begin, commaIndex - begin), this.parseDouble(buffer, commaIndex + 1, begin + len - commaIndex - 1));
            pointSerde.serialize((Object)this.aPoint, out);
        }
        catch (Exception e) {
            throw new ParseException(3074, e, new Serializable[]{new String(buffer, begin, len), "point"});
        }
    }

    protected void parse3DPoint(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        try {
            int firstCommaIndex = this.indexOf(buffer, begin, len, ',');
            int secondCommaIndex = this.indexOf(buffer, firstCommaIndex + 1, begin + len - firstCommaIndex - 1, ',');
            this.aPoint3D.setValue(this.parseDouble(buffer, begin, firstCommaIndex - begin), this.parseDouble(buffer, firstCommaIndex + 1, secondCommaIndex - firstCommaIndex - 1), this.parseDouble(buffer, secondCommaIndex + 1, begin + len - secondCommaIndex - 1));
            point3DSerde.serialize((Object)this.aPoint3D, out);
        }
        catch (Exception e) {
            throw new ParseException(3074, e, new Serializable[]{new String(buffer, begin, len), "point3d"});
        }
    }

    protected void parseCircle(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        try {
            int firstCommaIndex = this.indexOf(buffer, begin, len, ',');
            int spaceIndex = this.indexOf(buffer, firstCommaIndex + 1, begin + len - firstCommaIndex - 1, ' ');
            this.aPoint.setValue(this.parseDouble(buffer, begin, firstCommaIndex - begin), this.parseDouble(buffer, firstCommaIndex + 1, spaceIndex - firstCommaIndex - 1));
            this.aCircle.setValue((APoint)this.aPoint, this.parseDouble(buffer, spaceIndex + 1, begin + len - spaceIndex - 1));
            circleSerde.serialize((Object)this.aCircle, out);
        }
        catch (Exception e) {
            throw new ParseException(3074, e, new Serializable[]{new String(buffer, begin, len), "circle"});
        }
    }

    protected void parseRectangle(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        try {
            int spaceIndex = this.indexOf(buffer, begin, len, ' ');
            int firstCommaIndex = this.indexOf(buffer, begin, len, ',');
            this.aPoint.setValue(this.parseDouble(buffer, begin, firstCommaIndex - begin), this.parseDouble(buffer, firstCommaIndex + 1, spaceIndex - firstCommaIndex - 1));
            int secondCommaIndex = this.indexOf(buffer, spaceIndex + 1, begin + len - spaceIndex - 1, ',');
            this.aPoint2.setValue(this.parseDouble(buffer, spaceIndex + 1, secondCommaIndex - spaceIndex - 1), this.parseDouble(buffer, secondCommaIndex + 1, begin + len - secondCommaIndex - 1));
            if (this.aPoint.getX() > this.aPoint2.getX() && this.aPoint.getY() > this.aPoint2.getY()) {
                this.aRectangle.setValue((APoint)this.aPoint2, (APoint)this.aPoint);
            } else if (this.aPoint.getX() < this.aPoint2.getX() && this.aPoint.getY() < this.aPoint2.getY()) {
                this.aRectangle.setValue((APoint)this.aPoint, (APoint)this.aPoint2);
            } else {
                throw new IllegalArgumentException("Rectangle arugment must be either (bottom left point, top right point) or (top right point, bottom left point)");
            }
            rectangleSerde.serialize((Object)this.aRectangle, out);
        }
        catch (Exception e) {
            throw new ParseException(3074, e, new Serializable[]{new String(buffer, begin, len), "rectangle"});
        }
    }

    protected void parseLine(char[] buffer, int begin, int len, DataOutput out) throws HyracksDataException {
        try {
            int spaceIndex = this.indexOf(buffer, begin, len, ' ');
            int firstCommaIndex = this.indexOf(buffer, begin, len, ',');
            this.aPoint.setValue(this.parseDouble(buffer, begin, firstCommaIndex - begin), this.parseDouble(buffer, firstCommaIndex + 1, spaceIndex - firstCommaIndex - 1));
            int secondCommaIndex = this.indexOf(buffer, spaceIndex + 1, begin + len - spaceIndex - 1, ',');
            this.aPoint2.setValue(this.parseDouble(buffer, spaceIndex + 1, secondCommaIndex - spaceIndex - 1), this.parseDouble(buffer, secondCommaIndex + 1, begin + len - secondCommaIndex - 1));
            this.aLine.setValue((APoint)this.aPoint, (APoint)this.aPoint2);
            lineSerde.serialize((Object)this.aLine, out);
        }
        catch (Exception e) {
            throw new ParseException(3074, e, new Serializable[]{new String(buffer, begin, len), "line"});
        }
    }

    protected void parseHexBinaryString(char[] input, int start, int length, DataOutput out) throws HyracksDataException {
        this.hexParser.generateByteArrayFromHexString(input, start, length);
        this.aBinary.setValue(this.hexParser.getByteArray(), 0, this.hexParser.getLength());
        this.binarySerde.serialize((Object)this.aBinary, out);
    }

    protected void parseBase64BinaryString(char[] input, int start, int length, DataOutput out) throws HyracksDataException {
        this.base64Parser.generatePureByteArrayFromBase64String(input, start, length);
        this.aBinary.setValue(this.base64Parser.getByteArray(), 0, this.base64Parser.getLength());
        this.binarySerde.serialize((Object)this.aBinary, out);
    }

    protected long parseDatePart(String interval, int startOffset, int endOffset) throws HyracksDataException {
        while (interval.charAt(endOffset) == '\"' || interval.charAt(endOffset) == ' ') {
            --endOffset;
        }
        while (interval.charAt(startOffset) == '\"' || interval.charAt(startOffset) == ' ') {
            ++startOffset;
        }
        return ADateParserFactory.parseDatePart((String)interval, (int)startOffset, (int)(endOffset - startOffset + 1));
    }

    protected int parseTimePart(String interval, int startOffset, int endOffset) throws HyracksDataException {
        while (interval.charAt(endOffset) == '\"' || interval.charAt(endOffset) == ' ') {
            --endOffset;
        }
        while (interval.charAt(startOffset) == '\"' || interval.charAt(startOffset) == ' ') {
            ++startOffset;
        }
        return ATimeParserFactory.parseTimePart((String)interval, (int)startOffset, (int)(endOffset - startOffset + 1));
    }

    protected double parseDouble(char[] buffer, int begin, int len) {
        String str = new String(buffer, begin, len);
        return Double.valueOf(str);
    }

    protected float parseFloat(char[] buffer, int begin, int len) {
        String str = new String(buffer, begin, len);
        return Float.valueOf(str).floatValue();
    }

    protected int indexOf(char[] buffer, int begin, int len, char target) {
        for (int i = begin; i < begin + len; ++i) {
            if (buffer[i] != target) continue;
            return i;
        }
        throw new IllegalArgumentException("Cannot find " + target + " in " + new String(buffer, begin, len));
    }

    protected void parseString(char[] buffer, int begin, int length, DataOutput out) throws HyracksDataException {
        try {
            out.writeByte(ATypeTag.STRING.serialize());
            this.untaggedStringSerde.serialize(buffer, begin, length, out);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }
}

