/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.FileIndexTupleTranslator;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTree;
import org.apache.hyracks.storage.common.IIndex;

public class ExternalFilesIndexModificationOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private List<ExternalFile> files;
    private IIndexDataflowHelperFactory dataflowHelperFactory;

    public ExternalFilesIndexModificationOperatorDescriptor(IOperatorDescriptorRegistry spec, IIndexDataflowHelperFactory dataflowHelperFactory, List<ExternalFile> files) {
        super(spec, 0, 0);
        this.dataflowHelperFactory = dataflowHelperFactory;
        this.files = files;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
        return new AbstractOperatorNodePushable(){

            public void initialize() throws HyracksDataException {
                IIndexDataflowHelper indexHelper = ExternalFilesIndexModificationOperatorDescriptor.this.dataflowHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
                FileIndexTupleTranslator filesTupleTranslator = new FileIndexTupleTranslator();
                indexHelper.open();
                IIndex index = indexHelper.getIndexInstance();
                ExternalBTree.LSMTwoPCBTreeBulkLoader bulkLoader = null;
                HashMap parameters = new HashMap();
                try {
                    bulkLoader = (ExternalBTree.LSMTwoPCBTreeBulkLoader)((ExternalBTree)index).createTransactionBulkLoader(0.7f, false, (long)ExternalFilesIndexModificationOperatorDescriptor.this.files.size(), parameters);
                    block10: for (ExternalFile file : ExternalFilesIndexModificationOperatorDescriptor.this.files) {
                        switch (file.getPendingOp()) {
                            case ADD_OP: 
                            case APPEND_OP: {
                                bulkLoader.add(filesTupleTranslator.getTupleFromFile(file));
                                continue block10;
                            }
                            case DROP_OP: {
                                bulkLoader.delete(filesTupleTranslator.getTupleFromFile(file));
                                continue block10;
                            }
                            case NO_OP: {
                                continue block10;
                            }
                        }
                        throw HyracksDataException.create((int)17, (SourceLocation)ExternalFilesIndexModificationOperatorDescriptor.this.sourceLoc, (Serializable[])new Serializable[]{file.getPendingOp()});
                    }
                    bulkLoader.end();
                }
                catch (Exception e) {
                    if (bulkLoader != null) {
                        bulkLoader.abort();
                    }
                    throw HyracksDataException.create((Throwable)e);
                }
                finally {
                    indexHelper.close();
                }
            }

            public void deinitialize() throws HyracksDataException {
            }

            public int getInputArity() {
                return 0;
            }

            public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) throws HyracksDataException {
            }

            public IFrameWriter getInputFrameWriter(int index) {
                return null;
            }
        };
    }
}

