/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.ipc.MessageType;
import org.apache.asterix.external.ipc.PythonMessageBuilder;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.impl.Message;
import org.msgpack.core.MessagePack;

public class PythonIPCProto {
    public PythonMessageBuilder messageBuilder;
    OutputStream sockOut;
    ByteBuffer headerBuffer = ByteBuffer.allocate(21);
    ByteBuffer recvBuffer = ByteBuffer.allocate(4096);
    ExternalFunctionResultRouter router;
    IPCSystem ipcSys;
    Message outMsg;
    Long key;

    public PythonIPCProto(OutputStream sockOut, ExternalFunctionResultRouter router, IPCSystem ipcSys) throws IOException {
        this.sockOut = sockOut;
        this.messageBuilder = new PythonMessageBuilder();
        this.router = router;
        this.ipcSys = ipcSys;
        this.outMsg = new Message(null);
    }

    public void start() {
        this.key = this.router.insertRoute(this.recvBuffer);
    }

    public void helo() throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.buf.clear();
        this.messageBuilder.buf.position(0);
        this.messageBuilder.hello();
        this.sendMsg();
        this.receiveMsg();
        if (this.getResponseType() != MessageType.HELO) {
            throw new IllegalStateException("Illegal reply received, expected HELO");
        }
    }

    public void init(String module, String clazz, String fn) throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.buf.clear();
        this.messageBuilder.buf.position(0);
        this.messageBuilder.init(module, clazz, fn);
        this.sendMsg();
        this.receiveMsg();
        if (this.getResponseType() != MessageType.INIT_RSP) {
            throw new IllegalStateException("Illegal reply received, expected INIT_RSP");
        }
    }

    public ByteBuffer call(ByteBuffer args, int numArgs) throws Exception {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.buf.clear();
        this.messageBuilder.buf.position(0);
        this.messageBuilder.call(args.array(), args.position(), numArgs);
        this.sendMsg();
        this.receiveMsg();
        if (this.getResponseType() != MessageType.CALL_RSP) {
            throw new IllegalStateException("Illegal reply received, expected CALL_RSP, recvd: " + (Object)((Object)this.getResponseType()));
        }
        return this.recvBuffer;
    }

    public void quit() throws IOException {
        this.messageBuilder.quit();
        this.router.removeRoute(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMsg() throws IOException, AsterixException {
        Exception except = null;
        try {
            ByteBuffer byteBuffer = this.recvBuffer;
            synchronized (byteBuffer) {
                while (this.recvBuffer.limit() == 0) {
                    this.recvBuffer.wait(100L);
                }
            }
            if (this.router.hasException(this.key.longValue())) {
                except = this.router.getException(this.key);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AsterixException(201, (Throwable)e, new Serializable[0]);
        }
        if (except != null) {
            throw new AsterixException(201, (Throwable)except, new Serializable[0]);
        }
        this.messageBuilder.readHead(this.recvBuffer);
        if (this.messageBuilder.type == MessageType.ERROR) {
            throw new AsterixException(201, new Serializable[]{MessagePack.newDefaultUnpacker((ByteBuffer)this.recvBuffer).unpackString()});
        }
    }

    public void sendMsg() throws IOException {
        this.headerBuffer.clear();
        this.headerBuffer.position(0);
        this.headerBuffer.putInt(17 + this.messageBuilder.buf.position());
        this.headerBuffer.putLong(-1L);
        this.headerBuffer.putLong(this.key);
        this.headerBuffer.put((byte)0);
        this.sockOut.write(this.headerBuffer.array(), 0, 21);
        this.sockOut.write(this.messageBuilder.buf.array(), 0, this.messageBuilder.buf.position());
        this.sockOut.flush();
    }

    public MessageType getResponseType() {
        return this.messageBuilder.type;
    }
}

