/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.structures;

import java.util.Arrays;
import org.apache.hyracks.dataflow.std.structures.IHeap;
import org.apache.hyracks.dataflow.std.structures.IResetableComparable;
import org.apache.hyracks.dataflow.std.structures.IResetableComparableFactory;
import org.apache.hyracks.util.MathUtil;

public abstract class AbstractHeap
implements IHeap<IResetableComparable> {
    protected static final int NOT_EXIST = -1;
    protected static final int MAX_INITIAL_CAPACITY = 1024;
    protected IResetableComparable[] entries;
    protected IResetableComparable tempEntry;
    protected IResetableComparableFactory factory;
    protected int numEntry;

    public AbstractHeap(IResetableComparableFactory factory, int capacity) {
        capacity = Math.min(1024, Math.max(1, capacity));
        this.entries = new IResetableComparable[capacity];
        this.numEntry = 0;
        this.tempEntry = factory.createResetableComparable();
        this.factory = factory;
    }

    @Override
    public void insert(IResetableComparable element) {
        if (this.numEntry >= this.entries.length) {
            this.entries = Arrays.copyOf(this.entries, this.entries.length * 2);
        }
        if (this.entries[this.numEntry] == null) {
            this.entries[this.numEntry] = this.factory.createResetableComparable();
        }
        this.entries[this.numEntry++].reset(element);
        this.bubbleUp(this.numEntry - 1);
    }

    protected abstract void bubbleUp(int var1);

    protected abstract void trickleDown(int var1);

    protected void swap(int cid, int pid) {
        this.tempEntry.reset(this.entries[cid]);
        this.entries[cid].reset(this.entries[pid]);
        this.entries[pid].reset(this.tempEntry);
    }

    protected int compareTo(int i, int j) {
        return this.entries[i].compareTo(this.entries[j]);
    }

    @Override
    public boolean isEmpty() {
        return this.numEntry == 0;
    }

    @Override
    public void reset() {
        Arrays.fill(this.entries, null);
        this.numEntry = 0;
    }

    @Deprecated
    public IResetableComparable[] getEntries() {
        return this.entries;
    }

    @Override
    public int getNumEntries() {
        return this.numEntry;
    }

    protected int getLevel(int cid) {
        return MathUtil.log2Floor((int)(cid + 1));
    }

    static int getParentId(int cid) {
        return cid < 1 ? -1 : (cid - 1) / 2;
    }

    static int getLeftChild(int id, int numEntry) {
        int cid = id * 2 + 1;
        return cid >= numEntry ? -1 : cid;
    }

    protected int getLeftChild(int id) {
        return AbstractHeap.getLeftChild(id, this.numEntry);
    }

    static int getRightChild(int id, int numEntry) {
        int cid = id * 2 + 2;
        return cid >= numEntry ? -1 : cid;
    }

    protected int getRightChild(int id) {
        return AbstractHeap.getRightChild(id, this.numEntry);
    }

    protected int getGrandParentId(int id) {
        int pid = AbstractHeap.getParentId(id);
        return pid == -1 ? -1 : AbstractHeap.getParentId(pid);
    }

    protected boolean isDirectChild(int id, int childId) {
        return id == AbstractHeap.getParentId(childId);
    }

    protected int getMinChild(int id) {
        int rightCid;
        int min = -1;
        if (id != -1 && (min = AbstractHeap.getLeftChild(id, this.numEntry)) != -1 && (rightCid = AbstractHeap.getRightChild(id, this.numEntry)) != -1) {
            min = this.compareTo(rightCid, min) < 0 ? rightCid : min;
        }
        return min;
    }

    protected int getMaxChild(int id) {
        int rightCid;
        int max = -1;
        if (id != -1 && (max = AbstractHeap.getLeftChild(id, this.numEntry)) != -1 && (rightCid = AbstractHeap.getRightChild(id, this.numEntry)) != -1) {
            max = this.compareTo(rightCid, max) > 0 ? rightCid : max;
        }
        return max;
    }
}

