/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.connectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.IPartitionWriterFactory;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.util.trace.ITracer;

abstract class AbstractPartitionDataWriter
implements IFrameWriter {
    protected final int consumerPartitionCount;
    private final IFrameWriter[] pWriters;
    private final boolean[] isOpen;
    private final FrameTupleAppender[] appenders;
    protected final FrameTupleAccessor tupleAccessor;
    protected final IHyracksTaskContext ctx;
    private boolean[] allocatedFrames;
    private boolean failed = false;

    public AbstractPartitionDataWriter(IHyracksTaskContext ctx, int consumerPartitionCount, IPartitionWriterFactory pwFactory, RecordDescriptor recordDescriptor) throws HyracksDataException {
        this.ctx = ctx;
        this.consumerPartitionCount = consumerPartitionCount;
        this.pWriters = new IFrameWriter[consumerPartitionCount];
        this.isOpen = new boolean[consumerPartitionCount];
        this.allocatedFrames = new boolean[consumerPartitionCount];
        this.appenders = new FrameTupleAppender[consumerPartitionCount];
        this.tupleAccessor = new FrameTupleAccessor(recordDescriptor);
        this.initializeAppenders(pwFactory);
    }

    protected void initializeAppenders(IPartitionWriterFactory pwFactory) throws HyracksDataException {
        for (int i = 0; i < this.consumerPartitionCount; ++i) {
            try {
                this.pWriters[i] = pwFactory.createFrameWriter(i);
                this.appenders[i] = this.createTupleAppender(this.ctx);
                continue;
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    protected FrameTupleAppender createTupleAppender(IHyracksTaskContext ctx) {
        return new FrameTupleAppender();
    }

    public void close() throws HyracksDataException {
        HyracksDataException closeException = null;
        if (!this.failed) {
            boolean newFailure = false;
            for (int i = 0; i < this.pWriters.length; ++i) {
                try {
                    if (!this.isOpen[i] || !this.allocatedFrames[i] || this.appenders[i].getTupleCount() <= 0) continue;
                    this.appenders[i].write(this.pWriters[i], true);
                    continue;
                }
                catch (Exception e) {
                    newFailure = true;
                    closeException = this.wrapException(closeException, e);
                    break;
                }
            }
            if (newFailure) {
                try {
                    this.fail();
                }
                catch (Exception e) {
                    closeException = this.wrapException(closeException, e);
                }
            }
        }
        for (int i = 0; i < this.pWriters.length; ++i) {
            if (!this.isOpen[i]) continue;
            try {
                this.pWriters[i].close();
                continue;
            }
            catch (Exception e) {
                closeException = this.wrapException(closeException, e);
            }
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    public void open() throws HyracksDataException {
        for (int i = 0; i < this.pWriters.length; ++i) {
            this.isOpen[i] = true;
            this.pWriters[i].open();
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.tupleAccessor.reset(buffer);
        int tupleCount = this.tupleAccessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            this.processTuple(i);
        }
    }

    protected abstract void processTuple(int var1) throws HyracksDataException;

    protected void appendToPartitionWriter(int tupleIndex, int partition) throws HyracksDataException {
        if (!this.allocatedFrames[partition]) {
            this.allocateFrames(partition);
        }
        FrameUtils.appendToWriter((IFrameWriter)this.pWriters[partition], (IFrameTupleAppender)this.appenders[partition], (IFrameTupleAccessor)this.tupleAccessor, (int)tupleIndex);
    }

    protected void allocateFrames(int i) throws HyracksDataException {
        this.appenders[i].reset((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
        this.allocatedFrames[i] = true;
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        HyracksDataException failException = null;
        for (int i = 0; i < this.appenders.length; ++i) {
            if (!this.isOpen[i]) continue;
            try {
                this.pWriters[i].fail();
                continue;
            }
            catch (Exception e) {
                failException = this.wrapException(failException, e);
            }
        }
        if (failException != null) {
            throw failException;
        }
    }

    public void flush() throws HyracksDataException {
        for (int i = 0; i < this.consumerPartitionCount; ++i) {
            if (!this.allocatedFrames[i]) continue;
            this.appenders[i].flush(this.pWriters[i]);
        }
    }

    public void flush(ITracer tracer, String name, long cat, String args) throws HyracksDataException {
        for (int i = 0; i < this.consumerPartitionCount; ++i) {
            if (!this.allocatedFrames[i]) continue;
            this.appenders[i].flush(this.pWriters[i], tracer, name, cat, args);
        }
    }

    private HyracksDataException wrapException(HyracksDataException finalException, Exception currentException) {
        if (finalException == null) {
            return HyracksDataException.create((Throwable)currentException);
        }
        finalException.addSuppressed((Throwable)currentException);
        return finalException;
    }
}

