/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.messaging;

import java.io.IOException;
import org.apache.hyracks.api.comm.IBufferAcceptor;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.net.protocols.muxdemux.AbstractChannelReadInterface;

public class MessagingChannelReadInterface
extends AbstractChannelReadInterface {
    MessagingChannelReadInterface(IBufferAcceptor emptyBufferAcceptor) {
        this.emptyBufferAcceptor = emptyBufferAcceptor;
    }

    public int read(ISocketChannel sc, int size) throws IOException, NetException {
        while (size > 0) {
            int rSize;
            if (this.currentReadBuffer == null) {
                this.currentReadBuffer = this.bufferFactory.createBuffer();
            }
            if ((rSize = Math.min(size, this.currentReadBuffer.remaining())) > 0) {
                this.currentReadBuffer.limit(this.currentReadBuffer.position() + rSize);
                int len = sc.read(this.currentReadBuffer);
                if (len < 0) {
                    throw new NetException("Socket Closed");
                }
                size -= len;
                if (len < rSize) {
                    return size;
                }
            } else {
                return size;
            }
            if (this.currentReadBuffer.remaining() > 0) continue;
            this.flush();
        }
        return size;
    }
}

