/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.external;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.external.operators.LibraryDeployAbortOperatorDescriptor;
import org.apache.asterix.external.operators.LibraryDeployCommitOperatorDescriptor;
import org.apache.asterix.external.operators.LibraryDeployPrepareOperatorDescriptor;
import org.apache.asterix.external.operators.LibraryUndeployOperatorDescriptor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public class ExternalLibraryUtil {
    private ExternalLibraryUtil() {
    }

    public static Triple<JobSpecification, JobSpecification, JobSpecification> buildCreateLibraryJobSpec(DataverseName dataverseName, String libraryName, ExternalFunctionLanguage language, URI downloadURI, String authToken, MetadataProvider metadataProvider) {
        ICcApplicationContext appCtx = metadataProvider.getApplicationContext();
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = ExternalLibraryUtil.getSplitsAndConstraints(appCtx);
        JobSpecification prepareJobSpec = ExternalLibraryUtil.createLibraryPrepareJobSpec(dataverseName, libraryName, language, downloadURI, authToken, appCtx, splitsAndConstraint);
        JobSpecification commitJobSpec = ExternalLibraryUtil.createLibraryCommitJobSpec(dataverseName, libraryName, appCtx, splitsAndConstraint);
        JobSpecification abortJobSpec = ExternalLibraryUtil.createLibraryAbortJobSpec(dataverseName, libraryName, appCtx, splitsAndConstraint);
        return new Triple((Object)prepareJobSpec, (Object)commitJobSpec, (Object)abortJobSpec);
    }

    private static JobSpecification createLibraryPrepareJobSpec(DataverseName dataverseName, String libraryName, ExternalFunctionLanguage language, URI downloadURI, String authToken, ICcApplicationContext appCtx, Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint) {
        JobSpecification jobSpec = RuntimeUtils.createJobSpecification((ICcApplicationContext)appCtx);
        LibraryDeployPrepareOperatorDescriptor opDesc = new LibraryDeployPrepareOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, dataverseName, libraryName, language, downloadURI, authToken);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)jobSpec, (IOperatorDescriptor)opDesc, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        jobSpec.addRoot((IOperatorDescriptor)opDesc);
        return jobSpec;
    }

    private static JobSpecification createLibraryCommitJobSpec(DataverseName dataverseName, String libraryName, ICcApplicationContext appCtx, Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint) {
        JobSpecification jobSpec = RuntimeUtils.createJobSpecification((ICcApplicationContext)appCtx);
        LibraryDeployCommitOperatorDescriptor opDesc = new LibraryDeployCommitOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, dataverseName, libraryName);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)jobSpec, (IOperatorDescriptor)opDesc, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        return jobSpec;
    }

    private static JobSpecification createLibraryAbortJobSpec(DataverseName dataverseName, String libraryName, ICcApplicationContext appCtx, Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint) {
        JobSpecification jobSpec = RuntimeUtils.createJobSpecification((ICcApplicationContext)appCtx);
        LibraryDeployAbortOperatorDescriptor opDesc = new LibraryDeployAbortOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, dataverseName, libraryName);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)jobSpec, (IOperatorDescriptor)opDesc, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        return jobSpec;
    }

    public static JobSpecification buildDropLibraryJobSpec(DataverseName dataverseName, String libraryName, MetadataProvider metadataProvider) {
        ICcApplicationContext appCtx = metadataProvider.getApplicationContext();
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = ExternalLibraryUtil.getSplitsAndConstraints(appCtx);
        JobSpecification jobSpec = RuntimeUtils.createJobSpecification((ICcApplicationContext)appCtx);
        LibraryUndeployOperatorDescriptor opDesc = new LibraryUndeployOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, dataverseName, libraryName);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)jobSpec, (IOperatorDescriptor)opDesc, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        jobSpec.addRoot((IOperatorDescriptor)opDesc);
        return jobSpec;
    }

    private static Pair<IFileSplitProvider, AlgebricksPartitionConstraint> getSplitsAndConstraints(ICcApplicationContext appCtx) {
        FileSplit[] splits = ExternalLibraryUtil.getSplits(appCtx.getClusterStateManager());
        return StoragePathUtil.splitProviderAndPartitionConstraints((FileSplit[])splits);
    }

    private static FileSplit[] getSplits(IClusterStateManager clusterStateManager) {
        ClusterPartition[] clusterPartitions = clusterStateManager.getClusterPartitons();
        Arrays.sort(clusterPartitions, Comparator.comparing(ClusterPartition::getNodeId).thenComparingInt(ClusterPartition::getIODeviceNum));
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        for (ClusterPartition partition : clusterPartitions) {
            String activeNodeId = partition.getActiveNodeId();
            int n = splits.size();
            if (n > 0 && ((FileSplit)splits.get(n - 1)).getNodeName().equals(activeNodeId)) continue;
            FileSplit split = StoragePathUtil.getFileSplitForClusterPartition((ClusterPartition)partition, (String)".");
            splits.add(split);
        }
        return splits.toArray(new FileSplit[0]);
    }
}

