/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class KeyFieldTypeUtil {
    private KeyFieldTypeUtil() {
    }

    public static List<IAType> getPartitoningKeyTypes(Dataset dataset, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        if (dataset.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
            return null;
        }
        InternalDatasetDetails datasetDetails = (InternalDatasetDetails)dataset.getDatasetDetails();
        return KeyFieldTypeUtil.getPartitioningKeyTypes(datasetDetails, recordType, metaRecordType);
    }

    public static List<IAType> getPartitioningKeyTypes(InternalDatasetDetails datasetDetails, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        List<Integer> keySourceIndicators = datasetDetails.getKeySourceIndicator();
        List<List<String>> partitioningKeys = datasetDetails.getPartitioningKey();
        return KeyFieldTypeUtil.getKeyTypes(recordType, metaRecordType, partitioningKeys, keySourceIndicators);
    }

    public static List<IAType> getKeyTypes(ARecordType recordType, ARecordType metaRecordType, List<List<String>> keys, List<Integer> keySourceIndicators) throws AlgebricksException {
        ArrayList<IAType> keyTypes = new ArrayList<IAType>();
        int index = 0;
        for (List<String> partitioningKey : keys) {
            keyTypes.add(KeyFieldTypeUtil.chooseSource(keySourceIndicators, index, recordType, metaRecordType).getSubFieldType(partitioningKey));
            ++index;
        }
        return keyTypes;
    }

    public static List<IAType> getBTreeIndexKeyTypes(Index index, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        List<Integer> keySourceIndicators = index.getKeyFieldSourceIndicators();
        ArrayList<IAType> indexKeyTypes = new ArrayList<IAType>();
        for (int i = 0; i < index.getKeyFieldNames().size(); ++i) {
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(index.getKeyFieldTypes().get(i), index.getKeyFieldNames().get(i), KeyFieldTypeUtil.chooseSource(keySourceIndicators, i, recordType, metaRecordType));
            indexKeyTypes.add((IAType)keyPairType.first);
        }
        return indexKeyTypes;
    }

    public static List<IAType> getRTreeIndexKeyTypes(Index index, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        List<Integer> keySourceIndicators = index.getKeyFieldSourceIndicators();
        ArrayList<IAType> indexKeyTypes = new ArrayList<IAType>();
        ARecordType targetRecType = KeyFieldTypeUtil.chooseSource(keySourceIndicators, 0, recordType, metaRecordType);
        Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(index.getKeyFieldTypes().get(0), index.getKeyFieldNames().get(0), targetRecType);
        IAType keyType = (IAType)keyPairType.first;
        IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)keyType.getTypeTag());
        int numKeys = KeyFieldTypeUtil.getNumSecondaryKeys(index, targetRecType, metaRecordType);
        for (int i = 0; i < numKeys; ++i) {
            indexKeyTypes.add(nestedKeyType);
        }
        return indexKeyTypes;
    }

    public static int getNumSecondaryKeys(Index index, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        List<Integer> keySourceIndicators = index.getKeyFieldSourceIndicators();
        switch (index.getIndexType()) {
            case BTREE: 
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return index.getKeyFieldNames().size();
            }
            case RTREE: {
                Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(index.getKeyFieldTypes().get(0), index.getKeyFieldNames().get(0), KeyFieldTypeUtil.chooseSource(keySourceIndicators, 0, recordType, metaRecordType));
                IAType keyType = (IAType)keyPairType.first;
                return NonTaggedFormatUtil.getNumDimensions((ATypeTag)keyType.getTypeTag()) * 2;
            }
        }
        throw new CompilationException(1012, new Serializable[]{index.getIndexType()});
    }

    public static ARecordType chooseSource(List<Integer> keySourceIndicators, int index, ARecordType recordType, ARecordType metaRecordType) {
        return keySourceIndicators.get(index) == 0 ? recordType : metaRecordType;
    }
}

