/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Index;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;

public class DataSourceIndex
implements IDataSourceIndex<String, DataSourceId> {
    private final Index index;
    private final DataverseName dataverseName;
    private final String datasetName;
    private final MetadataProvider metadataProvider;

    public DataSourceIndex(Index index, DataverseName dataverseName, String datasetName, MetadataProvider metadataProvider) {
        this.index = index;
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.metadataProvider = metadataProvider;
    }

    public IDataSource<DataSourceId> getDataSource() {
        try {
            DataSourceId sourceId = new DataSourceId(this.dataverseName, this.datasetName);
            return this.metadataProvider.lookupSourceInMetadata(sourceId);
        }
        catch (Exception me) {
            return null;
        }
    }

    public String getId() {
        return this.index.getIndexName();
    }

    public Index getIndex() {
        return this.index;
    }
}

