/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.aql.clause.DistinctClause;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.expression.UnionExpr;
import org.apache.asterix.lang.aql.visitor.base.IAQLVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.rewrites.VariableSubstitutionEnvironment;
import org.apache.asterix.lang.common.util.VariableCloneAndSubstitutionUtil;
import org.apache.asterix.lang.common.visitor.CloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class AQLCloneAndSubstituteVariablesVisitor
extends CloneAndSubstituteVariablesVisitor
implements IAQLVisitor<Pair<ILangExpression, VariableSubstitutionEnvironment>, VariableSubstitutionEnvironment> {
    private LangRewritingContext context;

    public AQLCloneAndSubstituteVariablesVisitor(LangRewritingContext context) {
        super(context);
        this.context = context;
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(ForClause fc, VariableSubstitutionEnvironment env) throws CompilationException {
        Pair p1 = (Pair)fc.getInExpr().accept((ILangVisitor)this, (Object)env);
        VariableExpr varExpr = fc.getVarExpr();
        VariableExpr newVe = this.generateNewVariable(this.context, varExpr);
        VariableSubstitutionEnvironment resultEnv = new VariableSubstitutionEnvironment(env);
        resultEnv.removeSubstitution(varExpr);
        VariableExpr newPosVarExpr = null;
        if (fc.hasPosVar()) {
            VariableExpr posVarExpr = fc.getPosVarExpr();
            newPosVarExpr = this.generateNewVariable(this.context, posVarExpr);
            resultEnv.removeSubstitution(posVarExpr);
        }
        ForClause newFor = new ForClause(newVe, (Expression)p1.first, newPosVarExpr);
        return new Pair((Object)newFor, (Object)resultEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(FLWOGRExpression flwor, VariableSubstitutionEnvironment env) throws CompilationException {
        ArrayList<Clause> newClauses = new ArrayList<Clause>(flwor.getClauseList().size());
        VariableSubstitutionEnvironment currentEnv = env;
        for (Clause c : flwor.getClauseList()) {
            Pair p1 = (Pair)c.accept((ILangVisitor)this, (Object)currentEnv);
            currentEnv = (VariableSubstitutionEnvironment)p1.second;
            newClauses.add((Clause)p1.first);
        }
        Pair p2 = (Pair)flwor.getReturnExpr().accept((ILangVisitor)this, (Object)currentEnv);
        Expression newReturnExpr = (Expression)p2.first;
        FLWOGRExpression newFlwor = new FLWOGRExpression(newClauses, newReturnExpr);
        return new Pair((Object)newFlwor, p2.second);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(UnionExpr u, VariableSubstitutionEnvironment env) throws CompilationException {
        List exprList = VariableCloneAndSubstitutionUtil.visitAndCloneExprList(u.getExprs(), (VariableSubstitutionEnvironment)env, (CloneAndSubstituteVariablesVisitor)this);
        UnionExpr newU = new UnionExpr(exprList);
        return new Pair((Object)newU, (Object)env);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(DistinctClause dc, VariableSubstitutionEnvironment env) throws CompilationException {
        List exprList = VariableCloneAndSubstitutionUtil.visitAndCloneExprList(dc.getDistinctByExpr(), (VariableSubstitutionEnvironment)env, (CloneAndSubstituteVariablesVisitor)this);
        DistinctClause dc2 = new DistinctClause(exprList);
        return new Pair((Object)dc2, (Object)env);
    }
}

